/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT;
import jnt.FFT.Factorize;

public class ComplexFloatFFT_Mixed
extends ComplexFloatFFT {
    static final double PI = 3.1415927410125732;
    static final int FORWARD = -1;
    static final int BACKWARD = 1;
    private int[] factors;
    private float[][][] twiddle;
    private int[] available_factors = new int[]{7, 6, 5, 4, 3, 2};

    public ComplexFloatFFT_Mixed(int n) {
        super(n);
        this.setup_wavetable(n);
    }

    @Override
    public void transform(float[] fArray, int n, int n2) {
        this.checkData(fArray, n, n2);
        this.transform_internal(fArray, n, n2, -1);
    }

    @Override
    public void backtransform(float[] fArray, int n, int n2) {
        this.checkData(fArray, n, n2);
        this.transform_internal(fArray, n, n2, 1);
    }

    void setup_wavetable(int n) {
        if (n <= 0) {
            throw new Error("length must be positive integer : " + n);
        }
        this.n = n;
        this.factors = Factorize.factor(n, this.available_factors);
        double d = -6.2831854820251465 / (double)n;
        int n2 = 1;
        this.twiddle = new float[this.factors.length][][];
        for (int i = 0; i < this.factors.length; ++i) {
            int n3;
            int n4 = this.factors[i];
            int n5 = n2;
            int n6 = n / (n2 *= n4);
            this.twiddle[i] = new float[n6 + 1][2 * (n4 - 1)];
            float[][] fArray = this.twiddle[i];
            for (n3 = 1; n3 < n4; ++n3) {
                fArray[0][2 * (n3 - 1)] = 1.0f;
                fArray[0][2 * (n3 - 1) + 1] = 0.0f;
            }
            for (n3 = 1; n3 <= n6; ++n3) {
                int n7 = 0;
                for (int j = 1; j < n4; ++j) {
                    n7 += n3 * n5;
                    double d2 = d * (double)(n7 %= n);
                    fArray[n3][2 * (j - 1)] = (float)Math.cos(d2);
                    fArray[n3][2 * (j - 1) + 1] = (float)Math.sin(d2);
                }
            }
        }
    }

    void transform_internal(float[] fArray, int n, int n2, int n3) {
        int n4;
        if (this.n == 1) {
            return;
        }
        float[] fArray2 = new float[2 * this.n];
        int n5 = 1;
        boolean bl = false;
        block8: for (n4 = 0; n4 < this.factors.length; ++n4) {
            int n6;
            int n7;
            float[] fArray3;
            int n8;
            int n9;
            float[] fArray4;
            int n10 = this.factors[n4];
            n5 *= n10;
            if (!bl) {
                fArray4 = fArray;
                n9 = n;
                n8 = n2;
                fArray3 = fArray2;
                n7 = 0;
                n6 = 2;
                bl = true;
            } else {
                fArray4 = fArray2;
                n9 = 0;
                n8 = 2;
                fArray3 = fArray;
                n7 = n;
                n6 = n2;
                bl = false;
            }
            switch (n10) {
                case 2: {
                    this.pass_2(n4, fArray4, n9, n8, fArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 3: {
                    this.pass_3(n4, fArray4, n9, n8, fArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 4: {
                    this.pass_4(n4, fArray4, n9, n8, fArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 5: {
                    this.pass_5(n4, fArray4, n9, n8, fArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 6: {
                    this.pass_6(n4, fArray4, n9, n8, fArray3, n7, n6, n3, n5);
                    continue block8;
                }
                case 7: {
                    this.pass_7(n4, fArray4, n9, n8, fArray3, n7, n6, n3, n5);
                    continue block8;
                }
                default: {
                    this.pass_n(n4, fArray4, n9, n8, fArray3, n7, n6, n3, n10, n5);
                }
            }
        }
        if (bl) {
            for (n4 = 0; n4 < this.n; ++n4) {
                fArray[n + n2 * n4] = fArray2[2 * n4];
                fArray[n + n2 * n4 + 1] = fArray2[2 * n4 + 1];
            }
        }
    }

    void pass_2(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, int n6, int n7) {
        int n8 = 2;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = n3 * n9;
        int n13 = n5 * n11;
        int n14 = n2;
        int n15 = n4;
        for (int i = 0; i < n10; ++i) {
            float[] fArray3 = this.twiddle[n][i];
            float f = fArray3[0];
            float f2 = (float)(-n6) * fArray3[1];
            for (int j = 0; j < n11; ++j) {
                float f3 = fArray[n14];
                float f4 = fArray[n14 + 1];
                float f5 = fArray[n14 + n12];
                float f6 = fArray[n14 + n12 + 1];
                n14 += n3;
                fArray2[n15] = f3 + f5;
                fArray2[n15 + 1] = f4 + f6;
                float f7 = f3 - f5;
                float f8 = f4 - f6;
                fArray2[n15 + n13] = f * f7 - f2 * f8;
                fArray2[n15 + n13 + 1] = f * f8 + f2 * f7;
                n15 += n5;
            }
            n15 += (n8 - 1) * n13;
        }
    }

    void pass_3(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, int n6, int n7) {
        int n8 = 3;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        float f = (float)((double)n6 * Math.sqrt(3.0) / 2.0);
        int n13 = n3 * n9;
        int n14 = n5 * n11;
        int n15 = n2;
        int n16 = n4;
        for (int i = 0; i < n10; ++i) {
            float[] fArray3 = this.twiddle[n][i];
            float f2 = fArray3[0];
            float f3 = (float)(-n6) * fArray3[1];
            float f4 = fArray3[2];
            float f5 = (float)(-n6) * fArray3[3];
            for (int j = 0; j < n11; ++j) {
                float f6 = fArray[n15];
                float f7 = fArray[n15 + 1];
                float f8 = fArray[n15 + n13];
                float f9 = fArray[n15 + n13 + 1];
                float f10 = fArray[n15 + 2 * n13];
                float f11 = fArray[n15 + 2 * n13 + 1];
                n15 += n3;
                float f12 = f8 + f10;
                float f13 = f9 + f11;
                float f14 = f6 - f12 / 2.0f;
                float f15 = f7 - f13 / 2.0f;
                float f16 = f * (f8 - f10);
                float f17 = f * (f9 - f11);
                fArray2[n16] = f6 + f12;
                fArray2[n16 + 1] = f7 + f13;
                float f18 = f14 - f17;
                float f19 = f15 + f16;
                fArray2[n16 + n14] = f2 * f18 - f3 * f19;
                fArray2[n16 + n14 + 1] = f2 * f19 + f3 * f18;
                f18 = f14 + f17;
                f19 = f15 - f16;
                fArray2[n16 + 2 * n14] = f4 * f18 - f5 * f19;
                fArray2[n16 + 2 * n14 + 1] = f4 * f19 + f5 * f18;
                n16 += n5;
            }
            n16 += (n8 - 1) * n14;
        }
    }

    void pass_4(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, int n6, int n7) {
        int n8 = 4;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            float[] fArray3 = this.twiddle[n][i];
            float f = fArray3[0];
            float f2 = (float)(-n6) * fArray3[1];
            float f3 = fArray3[2];
            float f4 = (float)(-n6) * fArray3[3];
            float f5 = fArray3[4];
            float f6 = (float)(-n6) * fArray3[5];
            for (int j = 0; j < n11; ++j) {
                float f7 = fArray[n13];
                float f8 = fArray[n13 + 1];
                float f9 = fArray[n13 + n15];
                float f10 = fArray[n13 + n15 + 1];
                float f11 = fArray[n13 + 2 * n15];
                float f12 = fArray[n13 + 2 * n15 + 1];
                float f13 = fArray[n13 + 3 * n15];
                float f14 = fArray[n13 + 3 * n15 + 1];
                n13 += n3;
                float f15 = f7 + f11;
                float f16 = f8 + f12;
                float f17 = f9 + f13;
                float f18 = f10 + f14;
                float f19 = f7 - f11;
                float f20 = f8 - f12;
                float f21 = (float)n6 * (f9 - f13);
                float f22 = (float)n6 * (f10 - f14);
                fArray2[n14] = f15 + f17;
                fArray2[n14 + 1] = f16 + f18;
                float f23 = f19 - f22;
                float f24 = f20 + f21;
                fArray2[n14 + n16] = f * f23 - f2 * f24;
                fArray2[n14 + n16 + 1] = f * f24 + f2 * f23;
                f23 = f15 - f17;
                f24 = f16 - f18;
                fArray2[n14 + 2 * n16] = f3 * f23 - f4 * f24;
                fArray2[n14 + 2 * n16 + 1] = f3 * f24 + f4 * f23;
                f23 = f19 + f22;
                f24 = f20 - f21;
                fArray2[n14 + 3 * n16] = f5 * f23 - f6 * f24;
                fArray2[n14 + 3 * n16 + 1] = f5 * f24 + f6 * f23;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_5(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, int n6, int n7) {
        int n8 = 5;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        float f = (float)(Math.sqrt(5.0) / 4.0);
        float f2 = (float)((double)n6 * Math.sin(1.2566370964050293));
        float f3 = (float)((double)n6 * Math.sin(0.6283185482025146));
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            float[] fArray3 = this.twiddle[n][i];
            float f4 = fArray3[0];
            float f5 = (float)(-n6) * fArray3[1];
            float f6 = fArray3[2];
            float f7 = (float)(-n6) * fArray3[3];
            float f8 = fArray3[4];
            float f9 = (float)(-n6) * fArray3[5];
            float f10 = fArray3[6];
            float f11 = (float)(-n6) * fArray3[7];
            for (int j = 0; j < n11; ++j) {
                float f12 = fArray[n13];
                float f13 = fArray[n13 + 1];
                float f14 = fArray[n13 + n15];
                float f15 = fArray[n13 + n15 + 1];
                float f16 = fArray[n13 + 2 * n15];
                float f17 = fArray[n13 + 2 * n15 + 1];
                float f18 = fArray[n13 + 3 * n15];
                float f19 = fArray[n13 + 3 * n15 + 1];
                float f20 = fArray[n13 + 4 * n15];
                float f21 = fArray[n13 + 4 * n15 + 1];
                n13 += n3;
                float f22 = f14 + f20;
                float f23 = f15 + f21;
                float f24 = f16 + f18;
                float f25 = f17 + f19;
                float f26 = f14 - f20;
                float f27 = f15 - f21;
                float f28 = f16 - f18;
                float f29 = f17 - f19;
                float f30 = f22 + f24;
                float f31 = f23 + f25;
                float f32 = f * (f22 - f24);
                float f33 = f * (f23 - f25);
                float f34 = f12 - f30 / 4.0f;
                float f35 = f13 - f31 / 4.0f;
                float f36 = f34 + f32;
                float f37 = f35 + f33;
                float f38 = f34 - f32;
                float f39 = f35 - f33;
                float f40 = f2 * f26 + f3 * f28;
                float f41 = f2 * f27 + f3 * f29;
                float f42 = f3 * f26 - f2 * f28;
                float f43 = f3 * f27 - f2 * f29;
                fArray2[n14] = f12 + f30;
                fArray2[n14 + 1] = f13 + f31;
                float f44 = f36 - f41;
                float f45 = f37 + f40;
                fArray2[n14 + n16] = f4 * f44 - f5 * f45;
                fArray2[n14 + n16 + 1] = f4 * f45 + f5 * f44;
                f44 = f38 - f43;
                f45 = f39 + f42;
                fArray2[n14 + 2 * n16] = f6 * f44 - f7 * f45;
                fArray2[n14 + 2 * n16 + 1] = f6 * f45 + f7 * f44;
                f44 = f38 + f43;
                f45 = f39 - f42;
                fArray2[n14 + 3 * n16] = f8 * f44 - f9 * f45;
                fArray2[n14 + 3 * n16 + 1] = f8 * f45 + f9 * f44;
                f44 = f36 + f41;
                f45 = f37 - f40;
                fArray2[n14 + 4 * n16] = f10 * f44 - f11 * f45;
                fArray2[n14 + 4 * n16 + 1] = f10 * f45 + f11 * f44;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_6(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, int n6, int n7) {
        int n8 = 6;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        float f = (float)((double)n6 * Math.sqrt(3.0) / 2.0);
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            float[] fArray3 = this.twiddle[n][i];
            float f2 = fArray3[0];
            float f3 = (float)(-n6) * fArray3[1];
            float f4 = fArray3[2];
            float f5 = (float)(-n6) * fArray3[3];
            float f6 = fArray3[4];
            float f7 = (float)(-n6) * fArray3[5];
            float f8 = fArray3[6];
            float f9 = (float)(-n6) * fArray3[7];
            float f10 = fArray3[8];
            float f11 = (float)(-n6) * fArray3[9];
            for (int j = 0; j < n11; ++j) {
                float f12 = fArray[n13];
                float f13 = fArray[n13 + 1];
                float f14 = fArray[n13 + n15];
                float f15 = fArray[n13 + n15 + 1];
                float f16 = fArray[n13 + 2 * n15];
                float f17 = fArray[n13 + 2 * n15 + 1];
                float f18 = fArray[n13 + 3 * n15];
                float f19 = fArray[n13 + 3 * n15 + 1];
                float f20 = fArray[n13 + 4 * n15];
                float f21 = fArray[n13 + 4 * n15 + 1];
                float f22 = fArray[n13 + 5 * n15];
                float f23 = fArray[n13 + 5 * n15 + 1];
                n13 += n3;
                float f24 = f16 + f20;
                float f25 = f17 + f21;
                float f26 = f12 - f24 / 2.0f;
                float f27 = f13 - f25 / 2.0f;
                float f28 = f * (f16 - f20);
                float f29 = f * (f17 - f21);
                float f30 = f12 + f24;
                float f31 = f13 + f25;
                float f32 = f26 - f29;
                float f33 = f27 + f28;
                float f34 = f26 + f29;
                float f35 = f27 - f28;
                float f36 = f22 + f14;
                float f37 = f23 + f15;
                float f38 = f18 - f36 / 2.0f;
                float f39 = f19 - f37 / 2.0f;
                float f40 = f * (f22 - f14);
                float f41 = f * (f23 - f15);
                float f42 = f18 + f36;
                float f43 = f19 + f37;
                float f44 = f38 - f41;
                float f45 = f39 + f40;
                float f46 = f38 + f41;
                float f47 = f39 - f40;
                fArray2[n14] = f30 + f42;
                fArray2[n14 + 1] = f31 + f43;
                float f48 = f32 - f44;
                float f49 = f33 - f45;
                fArray2[n14 + n16] = f2 * f48 - f3 * f49;
                fArray2[n14 + n16 + 1] = f2 * f49 + f3 * f48;
                f48 = f34 + f46;
                f49 = f35 + f47;
                fArray2[n14 + 2 * n16] = f4 * f48 - f5 * f49;
                fArray2[n14 + 2 * n16 + 1] = f4 * f49 + f5 * f48;
                f48 = f30 - f42;
                f49 = f31 - f43;
                fArray2[n14 + 3 * n16] = f6 * f48 - f7 * f49;
                fArray2[n14 + 3 * n16 + 1] = f6 * f49 + f7 * f48;
                f48 = f32 + f44;
                f49 = f33 + f45;
                fArray2[n14 + 4 * n16] = f8 * f48 - f9 * f49;
                fArray2[n14 + 4 * n16 + 1] = f8 * f49 + f9 * f48;
                f48 = f34 - f46;
                f49 = f35 - f47;
                fArray2[n14 + 5 * n16] = f10 * f48 - f11 * f49;
                fArray2[n14 + 5 * n16 + 1] = f10 * f49 + f11 * f48;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_7(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, int n6, int n7) {
        int n8 = 7;
        int n9 = this.n / n8;
        int n10 = this.n / n7;
        int n11 = n7 / n8;
        int n12 = (n8 - 1) * n11;
        float f = (float)Math.cos(0.8975979260035923);
        float f2 = (float)Math.cos(1.7951958520071847);
        float f3 = (float)Math.cos(2.692793778010777);
        float f4 = (float)((double)(-n6) * Math.sin(0.8975979260035923));
        float f5 = (float)((double)(-n6) * Math.sin(1.7951958520071847));
        float f6 = (float)((double)(-n6) * Math.sin(2.692793778010777));
        int n13 = n2;
        int n14 = n4;
        int n15 = n3 * n9;
        int n16 = n5 * n11;
        for (int i = 0; i < n10; ++i) {
            float[] fArray3 = this.twiddle[n][i];
            float f7 = fArray3[0];
            float f8 = (float)(-n6) * fArray3[1];
            float f9 = fArray3[2];
            float f10 = (float)(-n6) * fArray3[3];
            float f11 = fArray3[4];
            float f12 = (float)(-n6) * fArray3[5];
            float f13 = fArray3[6];
            float f14 = (float)(-n6) * fArray3[7];
            float f15 = fArray3[8];
            float f16 = (float)(-n6) * fArray3[9];
            float f17 = fArray3[10];
            float f18 = (float)(-n6) * fArray3[11];
            for (int j = 0; j < n11; ++j) {
                float f19 = fArray[n13];
                float f20 = fArray[n13 + 1];
                float f21 = fArray[n13 + n15];
                float f22 = fArray[n13 + n15 + 1];
                float f23 = fArray[n13 + 2 * n15];
                float f24 = fArray[n13 + 2 * n15 + 1];
                float f25 = fArray[n13 + 3 * n15];
                float f26 = fArray[n13 + 3 * n15 + 1];
                float f27 = fArray[n13 + 4 * n15];
                float f28 = fArray[n13 + 4 * n15 + 1];
                float f29 = fArray[n13 + 5 * n15];
                float f30 = fArray[n13 + 5 * n15 + 1];
                float f31 = fArray[n13 + 6 * n15];
                float f32 = fArray[n13 + 6 * n15 + 1];
                n13 += n3;
                float f33 = f21 + f31;
                float f34 = f22 + f32;
                float f35 = f21 - f31;
                float f36 = f22 - f32;
                float f37 = f23 + f29;
                float f38 = f24 + f30;
                float f39 = f23 - f29;
                float f40 = f24 - f30;
                float f41 = f27 + f25;
                float f42 = f28 + f26;
                float f43 = f27 - f25;
                float f44 = f28 - f26;
                float f45 = f37 + f33;
                float f46 = f38 + f34;
                float f47 = f43 + f39;
                float f48 = f44 + f40;
                float f49 = f19 + f45 + f41;
                float f50 = f20 + f46 + f42;
                float f51 = ((f + f2 + f3) / 3.0f - 1.0f) * (f45 + f41);
                float f52 = ((f + f2 + f3) / 3.0f - 1.0f) * (f46 + f42);
                float f53 = (2.0f * f - f2 - f3) / 3.0f * (f33 - f41);
                float f54 = (2.0f * f - f2 - f3) / 3.0f * (f34 - f42);
                float f55 = (f - 2.0f * f2 + f3) / 3.0f * (f41 - f37);
                float f56 = (f - 2.0f * f2 + f3) / 3.0f * (f42 - f38);
                float f57 = (f + f2 - 2.0f * f3) / 3.0f * (f37 - f33);
                float f58 = (f + f2 - 2.0f * f3) / 3.0f * (f38 - f34);
                float f59 = (f4 + f5 - f6) / 3.0f * (f47 + f35);
                float f60 = (f4 + f5 - f6) / 3.0f * (f48 + f36);
                float f61 = (2.0f * f4 - f5 + f6) / 3.0f * (f35 - f43);
                float f62 = (2.0f * f4 - f5 + f6) / 3.0f * (f36 - f44);
                float f63 = (f4 - 2.0f * f5 - f6) / 3.0f * (f43 - f39);
                float f64 = (f4 - 2.0f * f5 - f6) / 3.0f * (f44 - f40);
                float f65 = (f4 + f5 + 2.0f * f6) / 3.0f * (f39 - f35);
                float f66 = (f4 + f5 + 2.0f * f6) / 3.0f * (f40 - f36);
                float f67 = f49 + f51;
                float f68 = f50 + f52;
                float f69 = f53 + f55;
                float f70 = f54 + f56;
                float f71 = f57 - f55;
                float f72 = f58 - f56;
                float f73 = -f53 - f57;
                float f74 = -f54 - f58;
                float f75 = f61 + f63;
                float f76 = f62 + f64;
                float f77 = f65 - f63;
                float f78 = f66 - f64;
                float f79 = -f65 - f61;
                float f80 = -f66 - f62;
                float f81 = f67 + f69;
                float f82 = f68 + f70;
                float f83 = f67 + f71;
                float f84 = f68 + f72;
                float f85 = f67 + f73;
                float f86 = f68 + f74;
                float f87 = f75 + f59;
                float f88 = f76 + f60;
                float f89 = f77 + f59;
                float f90 = f78 + f60;
                float f91 = f79 + f59;
                float f92 = f80 + f60;
                fArray2[n14] = f49;
                fArray2[n14 + 1] = f50;
                float f93 = f81 + f88;
                float f94 = f82 - f87;
                fArray2[n14 + n16] = f7 * f93 - f8 * f94;
                fArray2[n14 + n16 + 1] = f7 * f94 + f8 * f93;
                f93 = f85 + f92;
                f94 = f86 - f91;
                fArray2[n14 + 2 * n16] = f9 * f93 - f10 * f94;
                fArray2[n14 + 2 * n16 + 1] = f9 * f94 + f10 * f93;
                f93 = f83 - f90;
                f94 = f84 + f89;
                fArray2[n14 + 3 * n16] = f11 * f93 - f12 * f94;
                fArray2[n14 + 3 * n16 + 1] = f11 * f94 + f12 * f93;
                f93 = f83 + f90;
                f94 = f84 - f89;
                fArray2[n14 + 4 * n16] = f13 * f93 - f14 * f94;
                fArray2[n14 + 4 * n16 + 1] = f13 * f94 + f14 * f93;
                f93 = f85 - f92;
                f94 = f86 + f91;
                fArray2[n14 + 5 * n16] = f15 * f93 - f16 * f94;
                fArray2[n14 + 5 * n16 + 1] = f15 * f94 + f16 * f93;
                f93 = f81 - f88;
                f94 = f82 + f87;
                fArray2[n14 + 6 * n16] = f17 * f93 - f18 * f94;
                fArray2[n14 + 6 * n16 + 1] = f17 * f94 + f18 * f93;
                n14 += n5;
            }
            n14 += (n8 - 1) * n16;
        }
    }

    void pass_n(int n, float[] fArray, int n2, int n3, float[] fArray2, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        float f;
        float f2;
        int n11;
        int n12;
        int n13;
        int n14 = 0;
        int n15 = 0;
        int n16 = this.n / n7;
        int n17 = this.n / n8;
        int n18 = n8 / n7;
        int n19 = (n7 - 1) * n18;
        for (n14 = 0; n14 < n16; ++n14) {
            fArray2[n4 + n5 * n14] = fArray[n2 + n3 * n14];
            fArray2[n4 + n5 * n14 + 1] = fArray[n2 + n3 * n14 + 1];
        }
        for (n13 = 1; n13 < (n7 - 1) / 2 + 1; ++n13) {
            for (n14 = 0; n14 < n16; ++n14) {
                int n20 = n14 + n13 * n16;
                n12 = n14 + (n7 - n13) * n16;
                fArray2[n4 + n5 * n20] = fArray[n2 + n3 * n20] + fArray[n2 + n3 * n12];
                fArray2[n4 + n5 * n20 + 1] = fArray[n2 + n3 * n20 + 1] + fArray[n2 + n3 * n12 + 1];
                fArray2[n4 + n5 * n12] = fArray[n2 + n3 * n20] - fArray[n2 + n3 * n12];
                fArray2[n4 + n5 * n12 + 1] = fArray[n2 + n3 * n20 + 1] - fArray[n2 + n3 * n12 + 1];
            }
        }
        for (n14 = 0; n14 < n16; ++n14) {
            fArray[n2 + n3 * n14] = fArray2[n4 + n5 * n14];
            fArray[n2 + n3 * n14 + 1] = fArray2[n4 + n5 * n14 + 1];
        }
        for (n11 = 1; n11 < (n7 - 1) / 2 + 1; ++n11) {
            for (n14 = 0; n14 < n16; ++n14) {
                int n21 = n2 + n3 * n14;
                fArray[n21] = fArray[n21] + fArray2[n4 + n5 * (n14 + n11 * n16)];
                int n22 = n2 + n3 * n14 + 1;
                fArray[n22] = fArray[n22] + fArray2[n4 + n5 * (n14 + n11 * n16) + 1];
            }
        }
        float[] fArray3 = this.twiddle[n][n17];
        for (n13 = 1; n13 < (n7 - 1) / 2 + 1; ++n13) {
            n12 = n13;
            int n23 = n13 * n16;
            int n24 = (n7 - n13) * n16;
            for (n14 = 0; n14 < n16; ++n14) {
                fArray[n2 + n3 * (n14 + n23)] = fArray2[n4 + n5 * n14];
                fArray[n2 + n3 * (n14 + n23) + 1] = fArray2[n4 + n5 * n14 + 1];
                fArray[n2 + n3 * (n14 + n24)] = fArray2[n4 + n5 * n14];
                fArray[n2 + n3 * (n14 + n24) + 1] = fArray2[n4 + n5 * n14 + 1];
            }
            for (n11 = 1; n11 < (n7 - 1) / 2 + 1; ++n11) {
                if (n12 == 0) {
                    f2 = 1.0f;
                    f = 0.0f;
                } else {
                    f2 = fArray3[2 * (n12 - 1)];
                    f = (float)(-n6) * fArray3[2 * (n12 - 1) + 1];
                }
                for (n14 = 0; n14 < n16; ++n14) {
                    float f3 = f2 * fArray2[n4 + n5 * (n14 + n11 * n16)];
                    float f4 = f * fArray2[n4 + n5 * (n14 + (n7 - n11) * n16) + 1];
                    float f5 = f2 * fArray2[n4 + n5 * (n14 + n11 * n16) + 1];
                    float f6 = f * fArray2[n4 + n5 * (n14 + (n7 - n11) * n16)];
                    int n25 = n2 + n3 * (n14 + n23);
                    fArray[n25] = fArray[n25] + (f3 - f4);
                    int n26 = n2 + n3 * (n14 + n23) + 1;
                    fArray[n26] = fArray[n26] + (f5 + f6);
                    int n27 = n2 + n3 * (n14 + n24);
                    fArray[n27] = fArray[n27] + (f3 + f4);
                    int n28 = n2 + n3 * (n14 + n24) + 1;
                    fArray[n28] = fArray[n28] + (f5 - f6);
                }
                n12 += n13;
                n12 %= n7;
            }
        }
        n14 = 0;
        n15 = 0;
        for (n10 = 0; n10 < n18; ++n10) {
            fArray2[n4 + n5 * n10] = fArray[n2 + n3 * n10];
            fArray2[n4 + n5 * n10 + 1] = fArray[n2 + n3 * n10 + 1];
        }
        for (n11 = 1; n11 < n7; ++n11) {
            for (n10 = 0; n10 < n18; ++n10) {
                fArray2[n4 + n5 * (n10 + n11 * n18)] = fArray[n2 + n3 * (n10 + n11 * n16)];
                fArray2[n4 + n5 * (n10 + n11 * n18) + 1] = fArray[n2 + n3 * (n10 + n11 * n16) + 1];
            }
        }
        n14 = n18;
        n15 = n8;
        for (n9 = 1; n9 < n17; ++n9) {
            for (n10 = 0; n10 < n18; ++n10) {
                fArray2[n4 + n5 * n15] = fArray[n2 + n3 * n14];
                fArray2[n4 + n5 * n15 + 1] = fArray[n2 + n3 * n14 + 1];
                ++n14;
                ++n15;
            }
            n15 += n19;
        }
        n14 = n18;
        n15 = n8;
        for (n9 = 1; n9 < n17; ++n9) {
            fArray3 = this.twiddle[n][n9];
            for (n10 = 0; n10 < n18; ++n10) {
                for (n11 = 1; n11 < n7; ++n11) {
                    float f7 = fArray[n2 + n3 * (n14 + n11 * n16)];
                    f2 = fArray[n2 + n3 * (n14 + n11 * n16) + 1];
                    f = fArray3[2 * (n11 - 1)];
                    float f8 = (float)(-n6) * fArray3[2 * (n11 - 1) + 1];
                    fArray2[n4 + n5 * (n15 + n11 * n18)] = f * f7 - f8 * f2;
                    fArray2[n4 + n5 * (n15 + n11 * n18) + 1] = f * f2 + f8 * f7;
                }
                ++n14;
                ++n15;
            }
            n15 += n19;
        }
    }
}

