/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi.psd;

import edu.ucla.sspace.wordsi.AssignmentReporter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PseudoWordReporter
implements AssignmentReporter {
    private PrintStream writer;
    private final Map<String, Map<String, BitSet>> contextAssignments;
    private Map<String, Map<String, List<Integer>>> clusterCounts;

    public PseudoWordReporter(OutputStream outputStream) {
        this.writer = new PrintStream(outputStream);
        this.clusterCounts = new HashMap<String, Map<String, List<Integer>>>();
        this.contextAssignments = new HashMap<String, Map<String, BitSet>>();
    }

    @Override
    public synchronized void updateAssignment(String string, String string2, int n) {
        List<Integer> list;
        if (string.equals(string2)) {
            return;
        }
        Map<String, List<Integer>> map = this.clusterCounts.get(string);
        if (map == null) {
            map = new HashMap<String, List<Integer>>();
            this.clusterCounts.put(string, map);
        }
        if ((list = map.get(string2)) == null) {
            list = new ArrayList<Integer>(n);
            map.put(string2, list);
        }
        while (n >= list.size()) {
            list.add(0);
        }
        list.set(n, list.get(n) + 1);
    }

    @Override
    public void finalizeReport() {
        for (Map.Entry<String, Map<String, List<Integer>>> entry : this.clusterCounts.entrySet()) {
            String string = entry.getKey();
            for (Map.Entry<String, List<Integer>> entry2 : entry.getValue().entrySet()) {
                String string2 = entry2.getKey();
                List<Integer> list = entry2.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) <= 0) continue;
                    this.writer.printf("%s %s %d %d\n", string, string2, i, list.get(i));
                }
            }
        }
        this.writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assignContextToKey(String string, String string2, int n) {
        Object object;
        Object object2;
        Map<String, BitSet> map = this.contextAssignments.get(string);
        if (map == null) {
            object2 = this;
            synchronized (object2) {
                map = this.contextAssignments.get(string);
                if (map == null) {
                    map = new HashMap<String, BitSet>();
                    this.contextAssignments.put(string, map);
                }
            }
        }
        if ((object2 = map.get(string2)) == null) {
            object = this;
            synchronized (object) {
                object2 = map.get(string2);
                if (object2 == null) {
                    object2 = new BitSet();
                    map.put(string2, (BitSet)object2);
                }
            }
        }
        object = object2;
        synchronized (object) {
            ((BitSet)object2).set(n);
        }
    }

    @Override
    public String[] contextLabels(String string) {
        Map<String, BitSet> map = this.contextAssignments.get(string);
        if (map == null) {
            return new String[0];
        }
        int n = 0;
        for (Map.Entry<String, BitSet> object : map.entrySet()) {
            n = Math.max(n, object.getValue().length());
        }
        String[] stringArray = new String[n];
        for (Map.Entry<String, BitSet> entry : map.entrySet()) {
            BitSet bitSet = entry.getValue();
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                stringArray[n2] = entry.getKey();
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        return stringArray;
    }
}

