/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.wordsi;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyPathWeight;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.FilteredDependencyIterator;
import edu.ucla.sspace.dv.DependencyPathBasisMapping;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;

public class WordOccrrenceDependencyContextGenerator
implements DependencyContextGenerator {
    private final DependencyPathBasisMapping basisMapping;
    private final DependencyPathWeight weighter;
    private final int pathLength;
    private final DependencyPathAcceptor acceptor;

    public WordOccrrenceDependencyContextGenerator(DependencyPathBasisMapping dependencyPathBasisMapping, DependencyPathWeight dependencyPathWeight, DependencyPathAcceptor dependencyPathAcceptor, int n) {
        this.basisMapping = dependencyPathBasisMapping;
        this.weighter = dependencyPathWeight;
        this.acceptor = dependencyPathAcceptor;
        this.pathLength = n;
    }

    @Override
    public SparseDoubleVector generateContext(DependencyTreeNode[] dependencyTreeNodeArray, int n) {
        DependencyTreeNode dependencyTreeNode = dependencyTreeNodeArray[n];
        CompactSparseVector compactSparseVector = new CompactSparseVector();
        FilteredDependencyIterator filteredDependencyIterator = new FilteredDependencyIterator(dependencyTreeNode, this.acceptor, this.pathLength);
        while (filteredDependencyIterator.hasNext()) {
            DependencyPath dependencyPath = (DependencyPath)filteredDependencyIterator.next();
            int n2 = this.basisMapping.getDimension(dependencyPath);
            if (n2 < 0) continue;
            double d = this.weighter.scorePath(dependencyPath);
            compactSparseVector.add(n2, d);
        }
        return compactSparseVector;
    }

    @Override
    public int getVectorLength() {
        return this.basisMapping.numDimensions();
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.basisMapping.setReadOnly(bl);
    }
}

