/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vsm;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.common.GenericTermDocumentVectorSpace;
import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.Transform;
import edu.ucla.sspace.util.ReflectionUtil;
import java.io.IOError;
import java.io.IOException;
import java.util.Properties;

public class VectorSpaceModel
extends GenericTermDocumentVectorSpace {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.vsm.VectorSpaceModel";
    public static final String MATRIX_TRANSFORM_PROPERTY = "edu.ucla.sspace.vsm.VectorSpaceModel.transform";
    private static final String VSM_SSPACE_NAME = "vector-space-model";

    public VectorSpaceModel() throws IOException {
    }

    public VectorSpaceModel(boolean bl, BasisMapping<String, String> basisMapping, MatrixBuilder matrixBuilder) throws IOException {
        super(bl, basisMapping, matrixBuilder);
    }

    @Override
    public String getSpaceName() {
        return VSM_SSPACE_NAME;
    }

    @Override
    public void processSpace(Properties properties) {
        try {
            Transform transform = null;
            String string = properties.getProperty(MATRIX_TRANSFORM_PROPERTY);
            if (string != null) {
                transform = (Transform)ReflectionUtil.getObjectInstance(string);
            }
            MatrixFile matrixFile = this.processSpace(transform);
            this.wordSpace = MatrixIO.readMatrix(matrixFile.getFile(), matrixFile.getFormat());
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }
}

