/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorView;

class ViewVectorAsDoubleVector
extends VectorView<Double>
implements DoubleVector {
    private static final long serialVersionUID = 1L;

    public ViewVectorAsDoubleVector(Vector vector) {
        super(vector);
    }

    public ViewVectorAsDoubleVector(Vector vector, boolean bl) {
        super(vector, bl);
    }

    public ViewVectorAsDoubleVector(Vector vector, int n, int n2) {
        super(vector, n, n2);
    }

    public ViewVectorAsDoubleVector(Vector vector, int n, int n2, boolean bl) {
        super(vector, n, n2, bl);
    }

    @Override
    public double add(int n, double d) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        int n2 = this.getIndex(n);
        double d2 = this.vector.getValue(n2).doubleValue();
        this.vector.set(n2, d2 + d);
        return d2 + d;
    }

    @Override
    public void set(int n, double d) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        this.vector.set(this.getIndex(n), d);
    }

    @Override
    public double get(int n) {
        return this.vector.getValue(this.getIndex(n)).doubleValue();
    }

    @Override
    public Double getValue(int n) {
        return this.vector.getValue(this.getIndex(n)).doubleValue();
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.vectorLength - this.vectorOffset];
        for (int i = this.vectorOffset; i < this.vectorLength; ++i) {
            dArray[i] = this.vector.getValue(i).doubleValue();
        }
        return dArray;
    }
}

