/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.AmortizedSparseVector;
import edu.ucla.sspace.vector.AtomicVector;
import edu.ucla.sspace.vector.CompactSparseIntegerVector;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DenseIntVector;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleArrayAsVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.DoubleVectorView;
import edu.ucla.sspace.vector.IntArrayAsVector;
import edu.ucla.sspace.vector.IntAsDoubleVector;
import edu.ucla.sspace.vector.IntAsSparseDoubleVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.IntegerVectorView;
import edu.ucla.sspace.vector.ScaledDoubleVector;
import edu.ucla.sspace.vector.ScaledSparseDoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashIntegerVector;
import edu.ucla.sspace.vector.SparseIntegerVector;
import edu.ucla.sspace.vector.SparseIntegerVectorView;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.SynchronizedVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorView;
import edu.ucla.sspace.vector.ViewDoubleAsDoubleSparseVector;
import edu.ucla.sspace.vector.ViewIntegerAsIntegerSparseVector;
import edu.ucla.sspace.vector.ViewVectorAsDoubleVector;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public class Vectors {
    private Vectors() {
    }

    public static DoubleVector asDouble(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("Cannot re-type a null vector");
        }
        if (vector instanceof SparseIntegerVector) {
            return new IntAsSparseDoubleVector((SparseIntegerVector)vector);
        }
        if (vector instanceof SparseDoubleVector) {
            return (SparseDoubleVector)vector;
        }
        if (vector instanceof IntegerVector) {
            return new IntAsDoubleVector((IntegerVector)vector);
        }
        if (vector instanceof DoubleVector) {
            return (DoubleVector)vector;
        }
        return new ViewVectorAsDoubleVector(vector);
    }

    public static SparseDoubleVector asDouble(SparseIntegerVector sparseIntegerVector) {
        if (sparseIntegerVector == null) {
            throw new NullPointerException("Cannot re-type a null vector");
        }
        return new IntAsSparseDoubleVector(sparseIntegerVector);
    }

    public static DoubleVector asVector(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException("Cannot wrap a null array");
        }
        return new DoubleArrayAsVector(dArray);
    }

    public static IntegerVector asVector(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException("Cannot wrap a null array");
        }
        return new IntArrayAsVector(nArray);
    }

    public static boolean equals(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector.length() == doubleVector2.length()) {
            int n = doubleVector.length();
            for (int i = 0; i < n; ++i) {
                if (doubleVector.get(i) == doubleVector2.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(IntegerVector integerVector, IntegerVector integerVector2) {
        if (integerVector.length() == integerVector2.length()) {
            int n = integerVector.length();
            for (int i = 0; i < n; ++i) {
                if (integerVector.get(i) == integerVector2.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(Vector vector, Vector vector2) {
        if (vector.length() == vector2.length()) {
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                Number number;
                Number number2 = vector.getValue(i);
                if (number2.equals(number = vector2.getValue(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static DoubleVector immutable(DoubleVector doubleVector) {
        if (doubleVector == null) {
            throw new NullPointerException("Cannot create an immutable null vector");
        }
        return new DoubleVectorView(doubleVector, true);
    }

    public static SparseDoubleVector immutable(SparseDoubleVector sparseDoubleVector) {
        if (sparseDoubleVector == null) {
            throw new NullPointerException("Cannot create an immutable null vector");
        }
        return new ViewDoubleAsDoubleSparseVector(sparseDoubleVector, true);
    }

    public static IntegerVector immutable(IntegerVector integerVector) {
        if (integerVector == null) {
            throw new NullPointerException("Cannot create an immutable null vector");
        }
        return new IntegerVectorView(integerVector, true);
    }

    public static SparseIntegerVector immutable(SparseIntegerVector sparseIntegerVector) {
        if (sparseIntegerVector == null) {
            throw new NullPointerException("Cannot create an immutable null vector");
        }
        return new ViewIntegerAsIntegerSparseVector(sparseIntegerVector, true);
    }

    public static Vector immutable(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("Cannot create an immutable null vector");
        }
        return new VectorView(vector, true);
    }

    public static DoubleVector atomic(DoubleVector doubleVector) {
        if (doubleVector == null) {
            throw new NullPointerException("Cannot create an atomic null vector");
        }
        return new AtomicVector(doubleVector);
    }

    public static DoubleVector synchronizedVector(DoubleVector doubleVector) {
        if (doubleVector == null) {
            throw new NullPointerException("Cannot create an synchronized null vector");
        }
        return new SynchronizedVector(doubleVector);
    }

    public static DoubleVector scaleByMagnitude(DoubleVector doubleVector) {
        if (doubleVector instanceof SparseDoubleVector) {
            return Vectors.scaleByMagnitude((SparseDoubleVector)doubleVector);
        }
        return new ScaledDoubleVector(doubleVector, 1.0 / doubleVector.magnitude());
    }

    public static DoubleVector scaleByMagnitude(SparseDoubleVector sparseDoubleVector) {
        return new ScaledSparseDoubleVector(sparseDoubleVector, 1.0 / sparseDoubleVector.magnitude());
    }

    public static DoubleVector subview(DoubleVector doubleVector, int n, int n2) {
        if (doubleVector == null) {
            throw new NullPointerException("Cannot create view of a null vector");
        }
        return new DoubleVectorView(doubleVector, n, n2);
    }

    public static SparseDoubleVector subview(SparseDoubleVector sparseDoubleVector, int n, int n2) {
        if (sparseDoubleVector == null) {
            throw new NullPointerException("Cannot create view of a null vector");
        }
        return new ViewDoubleAsDoubleSparseVector(sparseDoubleVector, n, n2);
    }

    public static IntegerVector subview(IntegerVector integerVector, int n, int n2) {
        if (integerVector == null) {
            throw new NullPointerException("Cannot create view of a null vector");
        }
        return new IntegerVectorView(integerVector, n, n2);
    }

    public static SparseIntegerVector subview(SparseIntegerVector sparseIntegerVector, int n, int n2) {
        if (sparseIntegerVector == null) {
            throw new NullPointerException("Cannot create view of a null vector");
        }
        return new SparseIntegerVectorView(sparseIntegerVector, n, n2);
    }

    public static Vector copy(Vector vector, Vector vector2) {
        for (int i = 0; i < vector2.length(); ++i) {
            vector.set(i, vector2.getValue(i).doubleValue());
        }
        return vector;
    }

    public static DoubleVector copyOf(DoubleVector doubleVector) {
        if (doubleVector == null) {
            return null;
        }
        DoubleVector doubleVector2 = null;
        if (doubleVector instanceof SparseDoubleVector) {
            doubleVector2 = new CompactSparseVector(doubleVector.length());
            Vectors.copyFromSparseVector(doubleVector2, doubleVector);
        } else if (doubleVector instanceof DenseVector || doubleVector instanceof ScaledDoubleVector) {
            doubleVector2 = new DenseVector(doubleVector.length());
            for (int i = 0; i < doubleVector.length(); ++i) {
                doubleVector2.set(i, doubleVector.get(i));
            }
        } else if (doubleVector instanceof AmortizedSparseVector) {
            doubleVector2 = new AmortizedSparseVector(doubleVector.length());
            Vectors.copyFromSparseVector(doubleVector2, doubleVector);
        } else {
            if (doubleVector instanceof DoubleVectorView) {
                DoubleVectorView doubleVectorView = (DoubleVectorView)doubleVector;
                return Vectors.copyOf(doubleVectorView.getOriginalVector());
            }
            try {
                Class<?> clazz = doubleVector.getClass();
                Constructor<?> constructor = clazz.getConstructor(DoubleVector.class);
                doubleVector2 = (DoubleVector)constructor.newInstance(doubleVector);
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
        return doubleVector2;
    }

    public static Vector copyOf(Vector vector) {
        if (vector instanceof DoubleVector) {
            return Vectors.copyOf((DoubleVector)vector);
        }
        if (vector instanceof IntegerVector) {
            return Vectors.copyOf((IntegerVector)vector);
        }
        DenseVector denseVector = new DenseVector(vector.length());
        for (int i = 0; i < vector.length(); ++i) {
            denseVector.set(i, vector.getValue(i));
        }
        return denseVector;
    }

    public static IntegerVector copyOf(IntegerVector integerVector) {
        IntegerVector integerVector2 = null;
        if (integerVector instanceof TernaryVector) {
            TernaryVector ternaryVector = (TernaryVector)integerVector;
            int[] nArray = ternaryVector.positiveDimensions();
            int[] nArray2 = ternaryVector.negativeDimensions();
            integerVector2 = new TernaryVector(integerVector.length(), Arrays.copyOf(nArray, nArray.length), Arrays.copyOf(nArray2, nArray2.length));
        } else if (integerVector instanceof SparseVector) {
            integerVector2 = new SparseHashIntegerVector(integerVector.length());
            Vectors.copyFromSparseVector(integerVector2, integerVector);
        } else {
            integerVector2 = new DenseIntVector(integerVector.length());
            for (int i = 0; i < integerVector.length(); ++i) {
                integerVector2.set(i, integerVector.get(i));
            }
        }
        return integerVector2;
    }

    public static <T extends Vector> T instanceOf(T t) {
        if (t instanceof CompactSparseIntegerVector) {
            return (T)new CompactSparseIntegerVector(t.length());
        }
        try {
            Class<?> clazz = t.getClass();
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
            Vector vector = (Vector)constructor.newInstance(t.length());
            return (T)vector;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot instantiate a vector of type " + t.getClass(), exception);
        }
    }

    private static void copyFromSparseVector(DoubleVector doubleVector, DoubleVector doubleVector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)((Object)doubleVector2)).getNonZeroIndices()) {
            doubleVector.set(n, doubleVector2.get(n));
        }
    }

    private static void copyFromSparseVector(IntegerVector integerVector, IntegerVector integerVector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)((Object)integerVector2)).getNonZeroIndices()) {
            integerVector.set(n, integerVector2.get(n));
        }
    }
}

