/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseIntegerVector;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;

public class VectorMath {
    private VectorMath() {
    }

    public static Vector add(Vector vector, Vector vector2) {
        if (vector2.length() != vector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        if (vector2 instanceof IntegerVector && vector instanceof DoubleVector) {
            return VectorMath.add(vector, (Vector)Vectors.asDouble(vector2));
        }
        if (vector2 instanceof SparseVector) {
            VectorMath.addSparseValues(vector, vector2);
        } else {
            int n = vector2.length();
            for (int i = 0; i < n; ++i) {
                double d = vector2.getValue(i).doubleValue() + vector.getValue(i).doubleValue();
                vector.set(i, d);
            }
        }
        return vector;
    }

    public static DoubleVector add(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector2.length() != doubleVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added.  Lengths are: vector1: " + doubleVector.length() + ", vector2: " + doubleVector2.length());
        }
        if (doubleVector2 instanceof SparseVector) {
            VectorMath.addSparseValues(doubleVector, doubleVector2);
        } else {
            int n = doubleVector2.length();
            for (int i = 0; i < n; ++i) {
                double d = doubleVector2.get(i);
                if (d == 0.0) continue;
                doubleVector.add(i, d);
            }
        }
        return doubleVector;
    }

    public static IntegerVector add(IntegerVector integerVector, IntegerVector integerVector2) {
        if (integerVector2.length() != integerVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        if (integerVector2 instanceof SparseVector) {
            VectorMath.addSparseValues(integerVector, integerVector2);
        } else if (integerVector2 instanceof TernaryVector) {
            VectorMath.addTernaryValues(integerVector, (TernaryVector)integerVector2);
        } else {
            int n = integerVector2.length();
            for (int i = 0; i < n; ++i) {
                int n2 = integerVector2.get(i);
                if ((double)n2 == 0.0) continue;
                integerVector.add(i, n2);
            }
        }
        return integerVector;
    }

    public static Vector addUnmodified(Vector vector, Vector vector2) {
        if (vector2.length() != vector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        return VectorMath.addUnmodified(Vectors.asDouble(vector), Vectors.asDouble(vector2));
    }

    public static DoubleVector addUnmodified(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector2.length() != doubleVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        DoubleVector doubleVector3 = Vectors.copyOf(doubleVector);
        if (doubleVector2 instanceof SparseVector) {
            VectorMath.addSparseValues(doubleVector3, doubleVector2);
        } else {
            int n = doubleVector2.length();
            for (int i = 0; i < n; ++i) {
                double d = doubleVector2.get(i);
                doubleVector3.add(i, d);
            }
        }
        return doubleVector3;
    }

    public static IntegerVector addUnmodified(IntegerVector integerVector, IntegerVector integerVector2) {
        if (integerVector2.length() != integerVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        IntegerVector integerVector3 = Vectors.copyOf(integerVector);
        if (integerVector2 instanceof SparseVector) {
            VectorMath.addSparseValues(integerVector3, integerVector2);
        } else if (integerVector2 instanceof TernaryVector) {
            VectorMath.addTernaryValues(integerVector3, (TernaryVector)integerVector2);
        } else {
            int n = integerVector2.length();
            for (int i = 0; i < n; ++i) {
                int n2 = integerVector2.get(i);
                integerVector3.add(i, n2);
            }
        }
        return integerVector3;
    }

    public static Vector addWithScalars(Vector vector, double d, Vector vector2, double d2) {
        if (vector2.length() != vector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        int n = vector2.length();
        for (int i = 0; i < n; ++i) {
            double d3 = vector.getValue(i).doubleValue() * d + vector2.getValue(i).doubleValue() * d2;
            vector.set(i, d3);
        }
        return vector;
    }

    public static Vector addWithScalars(DoubleVector doubleVector, double d, DoubleVector doubleVector2, double d2) {
        if (doubleVector2.length() != doubleVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        int n = doubleVector2.length();
        for (int i = 0; i < n; ++i) {
            double d3 = doubleVector.get(i) * d + doubleVector2.get(i) * d2;
            doubleVector.set(i, d3);
        }
        return doubleVector;
    }

    public static Vector addWithScalars(IntegerVector integerVector, int n, IntegerVector integerVector2, int n2) {
        if (integerVector2.length() != integerVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        int n3 = integerVector2.length();
        for (int i = 0; i < n3; ++i) {
            double d = integerVector.get(i) * n + integerVector2.get(i) * n2;
            integerVector.set(i, d);
        }
        return integerVector;
    }

    public static double dotProduct(Vector vector, Vector vector2) {
        if (vector instanceof IntegerVector && vector2 instanceof IntegerVector) {
            return VectorMath.dotProduct((IntegerVector)vector, (IntegerVector)vector2);
        }
        return VectorMath.dotProduct(Vectors.asDouble(vector), Vectors.asDouble(vector2));
    }

    public static double dotProduct(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector.length() != doubleVector2.length()) {
            throw new IllegalArgumentException("cannot compute dot product of vectors with different lengths");
        }
        double d = 0.0;
        if (doubleVector instanceof SparseDoubleVector) {
            SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)doubleVector;
            for (int n : sparseDoubleVector.getNonZeroIndices()) {
                d += doubleVector.get(n) * doubleVector2.get(n);
            }
        } else if (doubleVector2 instanceof SparseDoubleVector) {
            SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)doubleVector2;
            for (int n : sparseDoubleVector.getNonZeroIndices()) {
                d += doubleVector.get(n) * doubleVector2.get(n);
            }
        } else {
            int n = doubleVector.length();
            for (int i = 0; i < n; ++i) {
                d += doubleVector.get(i) * doubleVector2.get(i);
            }
        }
        return d;
    }

    public static int dotProduct(IntegerVector integerVector, IntegerVector integerVector2) {
        if (integerVector.length() != integerVector2.length()) {
            throw new IllegalArgumentException("cannot compute dot product of vectors with different lengths");
        }
        int n = 0;
        if (integerVector instanceof SparseIntegerVector) {
            SparseIntegerVector sparseIntegerVector = (SparseIntegerVector)integerVector;
            for (int n2 : sparseIntegerVector.getNonZeroIndices()) {
                n += integerVector.get(n2) * integerVector2.get(n2);
            }
        } else if (integerVector2 instanceof SparseIntegerVector) {
            SparseIntegerVector sparseIntegerVector = (SparseIntegerVector)integerVector2;
            for (int n3 : sparseIntegerVector.getNonZeroIndices()) {
                n += integerVector.get(n3) * integerVector2.get(n3);
            }
        } else {
            int n4 = integerVector.length();
            for (int i = 0; i < n4; ++i) {
                n += integerVector.get(i) * integerVector2.get(i);
            }
        }
        return n;
    }

    public static Vector multiply(Vector vector, Vector vector2) {
        if (vector.length() != vector2.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be multiplied");
        }
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            vector.set(i, vector.getValue(i).doubleValue() * vector2.getValue(i).doubleValue());
        }
        return vector;
    }

    public static DoubleVector multiply(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector.length() != doubleVector2.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be multiplied");
        }
        int n = doubleVector.length();
        for (int i = 0; i < n; ++i) {
            doubleVector.set(i, doubleVector.get(i) * doubleVector2.get(i));
        }
        return doubleVector;
    }

    public static SparseDoubleVector multiplyUnmodified(SparseDoubleVector sparseDoubleVector, SparseDoubleVector sparseDoubleVector2) {
        CompactSparseVector compactSparseVector = new CompactSparseVector();
        int[] nArray = sparseDoubleVector.getNonZeroIndices();
        int[] nArray2 = sparseDoubleVector2.getNonZeroIndices();
        if (nArray.length == 0 || nArray2.length == 0) {
            return compactSparseVector;
        }
        if (nArray[nArray.length - 1] > nArray2[nArray2.length - 1]) {
            SparseDoubleVector sparseDoubleVector3 = sparseDoubleVector2;
            sparseDoubleVector2 = sparseDoubleVector;
            sparseDoubleVector = sparseDoubleVector3;
        }
        nArray = sparseDoubleVector.getNonZeroIndices();
        for (Object object : (SparseDoubleVector)nArray) {
            double d = sparseDoubleVector.get((int)object);
            double d2 = sparseDoubleVector2.get((int)object);
            if (d2 == 0.0) continue;
            compactSparseVector.set((int)object, d * d2);
        }
        return compactSparseVector;
    }

    public static IntegerVector multiply(IntegerVector integerVector, IntegerVector integerVector2) {
        if (integerVector.length() != integerVector2.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be multiplied");
        }
        int n = integerVector.length();
        for (int i = 0; i < n; ++i) {
            integerVector.set(i, integerVector.get(i) * integerVector2.get(i));
        }
        return integerVector;
    }

    public static DoubleVector multiplyUnmodified(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector.length() != doubleVector2.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be multiplied");
        }
        DoubleVector doubleVector3 = doubleVector instanceof SparseVector || doubleVector2 instanceof SparseVector ? new CompactSparseVector(doubleVector.length()) : new DenseVector(doubleVector.length());
        int n = doubleVector.length();
        for (int i = 0; i < n; ++i) {
            doubleVector3.set(i, doubleVector.get(i) * doubleVector2.get(i));
        }
        return doubleVector3;
    }

    public static Vector subtract(Vector vector, Vector vector2) {
        if (vector2.length() != vector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        if (vector2 instanceof IntegerVector && vector instanceof DoubleVector) {
            return VectorMath.subtract(vector, (Vector)Vectors.asDouble(vector2));
        }
        if (vector2 instanceof SparseVector) {
            VectorMath.subtractSparseValues(vector, vector2);
        } else {
            for (int i = 0; i < vector2.length(); ++i) {
                double d = vector.getValue(i).doubleValue() - vector2.getValue(i).doubleValue();
                vector.set(i, d);
            }
        }
        return vector;
    }

    public static DoubleVector subtract(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (doubleVector2.length() != doubleVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        if (doubleVector2 instanceof SparseVector) {
            VectorMath.subtractSparseValues(doubleVector, doubleVector2);
        } else {
            for (int i = 0; i < doubleVector2.length(); ++i) {
                double d = doubleVector2.get(i);
                if (d == 0.0) continue;
                doubleVector.add(i, -1.0 * d);
            }
        }
        return doubleVector;
    }

    public static IntegerVector subtract(IntegerVector integerVector, IntegerVector integerVector2) {
        if (integerVector2.length() != integerVector.length()) {
            throw new IllegalArgumentException("Vectors of different sizes cannot be added");
        }
        if (integerVector2 instanceof SparseVector) {
            VectorMath.subtractSparseValues(integerVector, integerVector2);
        } else if (integerVector2 instanceof TernaryVector) {
            VectorMath.subtractTernaryValues(integerVector, (TernaryVector)integerVector2);
        } else {
            for (int i = 0; i < integerVector2.length(); ++i) {
                int n = integerVector2.get(i);
                if ((double)n == 0.0) continue;
                integerVector.add(i, -1 * n);
            }
        }
        return integerVector;
    }

    private static void addSparseValues(DoubleVector doubleVector, DoubleVector doubleVector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)((Object)doubleVector2)).getNonZeroIndices()) {
            doubleVector.add(n, doubleVector2.get(n));
        }
    }

    private static void addSparseValues(IntegerVector integerVector, IntegerVector integerVector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)((Object)integerVector2)).getNonZeroIndices()) {
            integerVector.add(n, integerVector2.get(n));
        }
    }

    private static void addSparseValues(Vector vector, Vector vector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)vector2).getNonZeroIndices()) {
            double d = vector.getValue(n).doubleValue() + vector2.getValue(n).doubleValue();
            vector.set(n, d);
        }
    }

    private static void addTernaryValues(IntegerVector integerVector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            integerVector.add(n, 1);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            integerVector.add(n, -1);
        }
    }

    private static void addTernaryValues(DoubleVector doubleVector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            doubleVector.add(n, 1.0);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            doubleVector.add(n, -1.0);
        }
    }

    private static void addTernaryValues(Vector vector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            vector.set(n, 1.0 + vector.getValue(n).doubleValue());
        }
        for (int n : ternaryVector.negativeDimensions()) {
            vector.set(n, -1.0 + vector.getValue(n).doubleValue());
        }
    }

    private static void subtractSparseValues(DoubleVector doubleVector, DoubleVector doubleVector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)((Object)doubleVector2)).getNonZeroIndices()) {
            doubleVector.add(n, -1.0 * doubleVector2.get(n));
        }
    }

    private static void subtractSparseValues(IntegerVector integerVector, IntegerVector integerVector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)((Object)integerVector2)).getNonZeroIndices()) {
            integerVector.add(n, -1 * integerVector2.get(n));
        }
    }

    private static void subtractSparseValues(Vector vector, Vector vector2) {
        int[] nArray;
        for (int n : nArray = ((SparseVector)vector2).getNonZeroIndices()) {
            double d = vector.getValue(n).doubleValue() - vector2.getValue(n).doubleValue();
            vector.set(n, d);
        }
    }

    private static void subtractTernaryValues(IntegerVector integerVector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            integerVector.add(n, -1);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            integerVector.add(n, 1);
        }
    }

    private static void subtractTernaryValues(DoubleVector doubleVector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            doubleVector.add(n, -1.0);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            doubleVector.add(n, 1.0);
        }
    }

    private static void subtractTernaryValues(Vector vector, TernaryVector ternaryVector) {
        for (int n : ternaryVector.positiveDimensions()) {
            vector.set(n, vector.getValue(n).doubleValue() - 1.0);
        }
        for (int n : ternaryVector.negativeDimensions()) {
            vector.set(n, vector.getValue(n).doubleValue() + 1.0);
        }
    }
}

