/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;

public class VectorIO {
    private VectorIO() {
    }

    public static double[] readDoubleArray(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String[] stringArray = bufferedReader.readLine().trim().split("\\s+");
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        bufferedReader.close();
        return dArray;
    }

    public static String toString(Vector vector) {
        StringBuilder stringBuilder = new StringBuilder(vector.length() * 5);
        if (vector instanceof SparseDoubleVector) {
            SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)vector;
            int[] nArray = sparseDoubleVector.getNonZeroIndices();
            stringBuilder.append(nArray[0]).append(",").append(sparseDoubleVector.get(nArray[0]));
            for (int i = 1; i < nArray.length; ++i) {
                stringBuilder.append(";").append(nArray[i]).append(",").append(sparseDoubleVector.get(nArray[i]));
            }
        } else {
            for (int i = 0; i < vector.length() - 1; ++i) {
                stringBuilder.append(vector.getValue(i).doubleValue()).append(" ");
            }
            stringBuilder.append(vector.getValue(vector.length() - 1).doubleValue());
        }
        return stringBuilder.toString();
    }

    public static String toString(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder(dArray.length * 5);
        for (int i = 0; i < dArray.length - 1; ++i) {
            stringBuilder.append(dArray[i]).append(" ");
        }
        stringBuilder.append(dArray[dArray.length - 1]);
        return stringBuilder.toString();
    }

    public static String toString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 3);
        for (int i = 0; i < nArray.length - 1; ++i) {
            stringBuilder.append(nArray[i]).append(" ");
        }
        stringBuilder.append(nArray[nArray.length - 1]);
        return stringBuilder.toString();
    }

    public static void writeVector(int[] nArray, PrintWriter printWriter) throws IOException {
        printWriter.println(VectorIO.toString(nArray));
        printWriter.close();
    }

    public static void writeVector(int[] nArray, File file) throws IOException {
        VectorIO.writeVector(nArray, new PrintWriter(file));
    }

    public static void writeVector(int[] nArray, String string, File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("provided output directory file is not a directory: " + file);
        }
        string = string.replaceAll("/", "-SLASH-");
        File file2 = new File(file, string + ".vector");
        VectorIO.writeVector(nArray, file2);
    }
}

