/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.IntegerEntry;
import edu.ucla.sspace.util.ObjectEntry;
import edu.ucla.sspace.vector.SparseHashVector;
import edu.ucla.sspace.vector.SparseIntegerVector;
import java.io.Serializable;
import java.util.Iterator;

public class SparseHashIntegerVector
extends SparseHashVector<Integer>
implements SparseIntegerVector,
Iterable<IntegerEntry>,
Serializable {
    private static final long serialVersionUID = 1L;

    public SparseHashIntegerVector(int n) {
        super(n);
    }

    public SparseHashIntegerVector(int[] nArray) {
        super(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            this.vector.set(i, nArray[i]);
        }
    }

    @Override
    public int add(int n, int n2) {
        int n3 = this.get(n);
        this.set(n, n3 + n2);
        return n3 + n2;
    }

    @Override
    public int get(int n) {
        Number number = (Number)this.vector.get(n);
        return number == null ? 0 : number.intValue();
    }

    @Override
    public Integer getValue(int n) {
        return this.get(n);
    }

    @Override
    public Iterator<IntegerEntry> iterator() {
        return new IntegerIterator();
    }

    @Override
    public void set(int n, int n2) {
        this.vector.set(n, n2);
        this.magnitude = -1.0;
    }

    @Override
    public void set(int n, Number number) {
        this.vector.set(n, number);
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.length()];
        for (int n : this.vector.getElementIndices()) {
            nArray[n] = ((Number)this.vector.get(n)).intValue();
        }
        return nArray;
    }

    class IntegerIterator
    implements Iterator<IntegerEntry> {
        Iterator<ObjectEntry<Number>> it;

        public IntegerIterator() {
            this.it = SparseHashIntegerVector.this.vector.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public IntegerEntry next() {
            final ObjectEntry<Number> objectEntry = this.it.next();
            return new IntegerEntry(){

                @Override
                public int index() {
                    return objectEntry.index();
                }

                @Override
                public int value() {
                    return ((Number)objectEntry.value()).intValue();
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from vector");
        }
    }
}

