/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.VectorView;

public class MaskedDoubleVectorView
extends VectorView<Double>
implements DoubleVector {
    private static final long serialVersionUID = 1L;
    private final DoubleVector doubleVector;
    private final int[] columnMask;

    public MaskedDoubleVectorView(DoubleVector doubleVector, int[] nArray) {
        super(doubleVector, 0, nArray.length, false);
        this.doubleVector = doubleVector;
        this.columnMask = nArray;
    }

    @Override
    protected int getIndex(int n) {
        if (n < 0 || n > this.columnMask.length) {
            throw new IllegalArgumentException("The given index is not within the bounds of the masked vector");
        }
        return this.columnMask[n];
    }

    @Override
    public double add(int n, double d) {
        int n2 = this.getIndex(n);
        return n2 == -1 ? 0.0 : this.doubleVector.add(n2, d);
    }

    @Override
    public void set(int n, double d) {
        int n2 = this.getIndex(n);
        if (n2 == -1) {
            return;
        }
        this.doubleVector.set(n2, d);
    }

    @Override
    public double get(int n) {
        int n2 = this.getIndex(n);
        return n2 == -1 ? 0.0 : this.doubleVector.get(n2);
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.length()];
        for (int i = 0; i < this.length(); ++i) {
            dArray[i] = this.get(i);
        }
        return dArray;
    }

    @Override
    public int length() {
        return this.columnMask.length;
    }

    public DoubleVector getOriginalVector() {
        return this.doubleVector;
    }
}

