/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.VectorView;

class IntegerVectorView
extends VectorView<Integer>
implements IntegerVector {
    private static final long serialVersionUID = 1L;
    protected final IntegerVector intVector;

    public IntegerVectorView(IntegerVector integerVector) {
        this(integerVector, 0, integerVector.length(), false);
    }

    public IntegerVectorView(IntegerVector integerVector, boolean bl) {
        this(integerVector, 0, integerVector.length(), bl);
    }

    public IntegerVectorView(IntegerVector integerVector, int n, int n2) {
        this(integerVector, n, n2, false);
    }

    public IntegerVectorView(IntegerVector integerVector, int n, int n2, boolean bl) {
        super(integerVector, n, n2, bl);
        this.intVector = integerVector;
    }

    @Override
    public int add(int n, int n2) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        return this.intVector.add(this.getIndex(n), n2);
    }

    @Override
    public void set(int n, int n2) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        this.intVector.set(this.getIndex(n), n2);
    }

    @Override
    public int get(int n) {
        return this.intVector.get(this.getIndex(n));
    }

    @Override
    public Integer getValue(int n) {
        return this.intVector.get(this.getIndex(n));
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            for (int i = this.vectorOffset; i < this.vectorOffset + this.vectorLength; ++i) {
                int n = this.intVector.get(i);
                d += (double)(n * n);
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }

    @Override
    public int[] toArray() {
        if (this.vectorOffset > 0 || this.vectorLength != this.vector.length()) {
            int[] nArray = new int[this.vectorLength - this.vectorOffset];
            for (int i = this.vectorOffset; i < this.vectorLength; ++i) {
                nArray[i] = this.intVector.get(i);
            }
            return nArray;
        }
        return this.intVector.toArray();
    }
}

