/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.VectorView;

class DoubleVectorView
extends VectorView<Double>
implements DoubleVector {
    private static final long serialVersionUID = 1L;
    protected final DoubleVector doubleVector;

    public DoubleVectorView(DoubleVector doubleVector) {
        this(doubleVector, 0, doubleVector.length(), false);
    }

    public DoubleVectorView(DoubleVector doubleVector, boolean bl) {
        this(doubleVector, 0, doubleVector.length(), bl);
    }

    public DoubleVectorView(DoubleVector doubleVector, int n, int n2) {
        this(doubleVector, n, n2, false);
    }

    public DoubleVectorView(DoubleVector doubleVector, int n, int n2, boolean bl) {
        super(doubleVector, n, n2, bl);
        this.doubleVector = doubleVector;
    }

    @Override
    public double add(int n, double d) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        return this.doubleVector.add(this.getIndex(n), d);
    }

    @Override
    public void set(int n, double d) {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Cannot modify an immutable vector");
        }
        this.doubleVector.set(this.getIndex(n), d);
    }

    @Override
    public double get(int n) {
        return this.doubleVector.get(this.getIndex(n));
    }

    @Override
    public Double getValue(int n) {
        return this.doubleVector.get(this.getIndex(n));
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            for (int i = this.vectorOffset; i < this.vectorOffset + this.vectorLength; ++i) {
                double d2 = this.doubleVector.get(i);
                d += d2 * d2;
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }

    @Override
    public double[] toArray() {
        if (this.vectorOffset > 0 || this.vectorLength != this.vector.length()) {
            double[] dArray = new double[this.vectorLength - this.vectorOffset];
            for (int i = this.vectorOffset; i < this.vectorLength; ++i) {
                dArray[i] = this.doubleVector.get(i);
            }
            return dArray;
        }
        return this.doubleVector.toArray();
    }

    public DoubleVector getOriginalVector() {
        return this.doubleVector;
    }
}

