/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.vector;

import edu.ucla.sspace.util.DoubleEntry;
import edu.ucla.sspace.util.SparseDoubleArray;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.Serializable;
import java.util.Iterator;

public class CompactSparseVector
implements SparseDoubleVector,
Serializable,
Iterable<DoubleEntry> {
    private static final long serialVersionUID = 1L;
    private SparseDoubleArray vector;
    private double magnitude;

    public CompactSparseVector() {
        this.vector = new SparseDoubleArray();
        this.magnitude = 0.0;
    }

    public CompactSparseVector(int n) {
        this.vector = new SparseDoubleArray(n);
        this.magnitude = 0.0;
    }

    public CompactSparseVector(double[] dArray) {
        this.vector = new SparseDoubleArray(dArray);
        this.magnitude = -1.0;
    }

    public CompactSparseVector(SparseDoubleVector sparseDoubleVector) {
        int n = sparseDoubleVector.length();
        int[] nArray = sparseDoubleVector.getNonZeroIndices();
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = sparseDoubleVector.get(nArray[i]);
        }
        this.vector = new SparseDoubleArray(nArray, dArray, n);
        this.magnitude = -1.0;
    }

    public CompactSparseVector(int[] nArray, double[] dArray, int n) {
        this.vector = new SparseDoubleArray(nArray, dArray, n);
        this.magnitude = -1.0;
    }

    @Override
    public double add(int n, double d) {
        this.magnitude = -1.0;
        return this.vector.addPrimitive(n, d);
    }

    @Override
    public Iterator<DoubleEntry> iterator() {
        return this.vector.iterator();
    }

    public void set(double[] dArray) {
        this.vector = new SparseDoubleArray(dArray);
        this.magnitude = -1.0;
    }

    @Override
    public void set(int n, double d) {
        this.vector.setPrimitive(n, d);
        this.magnitude = -1.0;
    }

    @Override
    public void set(int n, Number number) {
        this.set(n, number.doubleValue());
    }

    @Override
    public int[] getNonZeroIndices() {
        return this.vector.getElementIndices();
    }

    @Override
    public double magnitude() {
        if (this.magnitude < 0.0) {
            double d = 0.0;
            for (DoubleEntry doubleEntry : this) {
                d += doubleEntry.value() * doubleEntry.value();
            }
            this.magnitude = Math.sqrt(d);
        }
        return this.magnitude;
    }

    @Override
    public double[] toArray() {
        double[] dArray = new double[this.vector.length()];
        return this.vector.toPrimitiveArray(dArray);
    }

    @Override
    public double get(int n) {
        return this.vector.getPrimitive(n);
    }

    @Override
    public Double getValue(int n) {
        return this.get(n);
    }

    @Override
    public int length() {
        return this.vector.length();
    }
}

