/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeSpan {
    private static final Pattern TIME_SPAN_PATTERN = Pattern.compile("\\d+[a-zA-Z]");
    private final int years;
    private final int months;
    private final int weeks;
    private final int days;
    private final int hours;

    public TimeSpan(String string) {
        Matcher matcher = TIME_SPAN_PATTERN.matcher(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        block7: while (matcher.find()) {
            if (matcher.start() != n7) {
                throw new IllegalArgumentException("invalid time unit format: " + string);
            }
            n7 = matcher.end();
            String string2 = string.substring(matcher.start(), matcher.end() - 1);
            int n8 = Integer.parseInt(string2);
            TimeSpan.checkDuration(n8);
            char c = string.charAt(matcher.end() - 1);
            switch (c) {
                case 'y': {
                    TimeSpan.checkSetTwice(n, 0, "years");
                    n |= 1;
                    n2 = n8;
                    continue block7;
                }
                case 'm': {
                    TimeSpan.checkSetTwice(n, 1, "months");
                    n |= 2;
                    n3 = n8;
                    continue block7;
                }
                case 'w': {
                    TimeSpan.checkSetTwice(n, 2, "weeks");
                    n |= 4;
                    n4 = n8;
                    continue block7;
                }
                case 'd': {
                    TimeSpan.checkSetTwice(n, 3, "days");
                    n |= 8;
                    n5 = n8;
                    continue block7;
                }
                case 'h': {
                    TimeSpan.checkSetTwice(n, 4, "hours");
                    n |= 0x10;
                    n6 = n8;
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unknown time unit: " + c);
        }
        this.years = n2;
        this.months = n3;
        this.weeks = n4;
        this.days = n5;
        this.hours = n6;
    }

    public TimeSpan(int n, int n2, int n3, int n4, int n5) {
        TimeSpan.checkDuration(n);
        TimeSpan.checkDuration(n2);
        TimeSpan.checkDuration(n3);
        TimeSpan.checkDuration(n4);
        TimeSpan.checkDuration(n5);
        this.years = n;
        this.months = n2;
        this.weeks = n3;
        this.days = n4;
        this.hours = n5;
    }

    public void addTo(Calendar calendar) {
        calendar.add(1, this.years);
        calendar.add(2, this.months);
        calendar.add(3, this.weeks);
        calendar.add(6, this.days);
        calendar.add(11, this.hours);
    }

    public void addTo(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.addTo(calendar);
        date.setTime(calendar.getTime().getTime());
    }

    private static void checkSetTwice(int n, int n2, String string) {
        if ((n & 1 << n2) != 0) {
            throw new IllegalArgumentException(string + " is set twice");
        }
    }

    private static void checkDuration(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Duration must be non-negative");
        }
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMonths() {
        return this.months;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public int getYears() {
        return this.years;
    }

    public boolean insideRange(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = (Calendar)calendar.clone();
        return this.isInRange(calendar3, calendar2);
    }

    private boolean isInRange(Calendar calendar, Calendar calendar2) {
        if (calendar2.before(calendar)) {
            return false;
        }
        Calendar calendar3 = calendar;
        calendar3.add(1, this.years);
        calendar3.add(2, this.months);
        calendar3.add(3, this.weeks);
        calendar3.add(6, this.days);
        calendar3.add(10, this.hours);
        return calendar2.before(calendar3);
    }

    public boolean insideRange(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        return this.isInRange(calendar, calendar2);
    }

    public boolean insideRange(long l, long l2) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        calendar2.setTimeInMillis(l2);
        return this.isInRange(calendar, calendar2);
    }

    public String toString() {
        return String.format("TimeSpan: %dy%dm%dw%dd%dh", this.years, this.months, this.weeks, this.days, this.hours);
    }
}

