/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineReader
implements Iterable<String> {
    private final File f;

    public LineReader(File file) {
        this.f = file;
    }

    @Override
    public Iterator<String> iterator() {
        return new LineIterator();
    }

    private class LineIterator
    implements Iterator<String> {
        private final BufferedReader br;
        private String next;

        public LineIterator() {
            try {
                this.br = new BufferedReader(new FileReader(LineReader.this.f));
                this.advance();
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }

        private void advance() {
            try {
                this.next = this.br.readLine();
                if (this.next == null) {
                    this.br.close();
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String string = this.next;
            this.advance();
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove line from file");
        }
    }
}

