/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CombinedIterator<T>
implements Iterator<T> {
    private final Queue<Iterator<T>> iters = new ArrayDeque<Iterator<T>>();
    private Iterator<T> current;
    private Iterator<T> prev;

    public CombinedIterator(Iterator<T> ... iteratorArray) {
        this(Arrays.asList(iteratorArray));
    }

    public CombinedIterator(Collection<Iterator<T>> collection) {
        this.iters.addAll(collection);
        this.current = this.iters.poll();
    }

    private void advance() {
        while (this.current != null && !this.current.hasNext()) {
            this.prev = this.current;
            this.current = this.iters.poll();
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return this.current != null && this.current.hasNext();
    }

    @Override
    public synchronized T next() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        T t = this.current.next();
        this.advance();
        return t;
    }

    @Override
    public synchronized void remove() {
        if (this.prev == null) {
            throw new NoSuchElementException();
        }
        this.prev.remove();
    }
}

