/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.util;

import edu.ucla.sspace.util.BoundedSortedMap;
import edu.ucla.sspace.util.TreeMultiMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BoundedSortedMultiMap<K, V>
extends TreeMultiMap<K, V> {
    private static final long serialVersionUID = 1L;
    private final int bound;
    private final boolean isKeyBound;
    private final boolean isFair;

    public BoundedSortedMultiMap(int n) {
        this(n, false, true, false);
    }

    public BoundedSortedMultiMap(int n, boolean bl) {
        this(n, bl, true, false);
    }

    public BoundedSortedMultiMap(int n, boolean bl, boolean bl2, boolean bl3) {
        super(bl2 ? null : new BoundedSortedMap.ReverseComparator());
        this.isKeyBound = bl;
        this.bound = n;
        this.isFair = bl3;
    }

    @Override
    public boolean put(K k, V v) {
        boolean bl = super.put(k, v);
        if (this.isKeyBound) {
            if (this.size() > this.bound) {
                this.remove(this.firstKey());
            }
        } else if (this.range() > this.bound) {
            Object k2 = this.firstKey();
            Set set = this.get(k2);
            int n = 0;
            if (this.isFair) {
                n = (int)(Math.random() * (double)set.size());
                Object v2 = null;
                Iterator iterator = set.iterator();
                for (int i = 0; i <= n; ++i) {
                    v2 = iterator.next();
                }
                this.remove(k2, v2);
            } else {
                this.remove(k2, set.iterator().next());
            }
        }
        return bl;
    }

    @Override
    public boolean putMulti(K k, Collection<V> collection) {
        boolean bl = false;
        for (V v : collection) {
            if (!this.put(k, v)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

