/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.common.ArgOptions;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PsudoWordSelector {
    private static boolean usePos;

    public static void usage(ArgOptions argOptions) {
        System.out.println("Usage: PseudoWordselector [options] <word_scores> <out>\n" + argOptions.prettyPrint());
        System.exit(1);
    }

    public static void main(String[] stringArray) throws Exception {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('w', "wordList", "Specifies the wods that should be used in a pseudo word list", true, "FILE", "Required (One of)");
        argOptions.addOption('n', "numberOfPseudoWords", "Specifies the desired number of pseudo words to create. If usePartsOfSpeech is set, this number of words per part of speech will be selected", true, "INT", "Requred (One of)");
        argOptions.addOption('P', "usePartsOfSpeech", "If set, all terms are expected to have their part of speech as a suffix.  Terms should have the form lemma-POS", false, null, "Optional");
        argOptions.addOption('t', "typeOfPseudoWord", "Specifies the specificity of the selected pseudo word confounders.  high will pick the word with the closest score.  med will select a score randomly from the 100 closest scoring words and low will select any confounder at random", true, "high|med|low", "Required");
        argOptions.parseOptions(stringArray);
        if (!argOptions.hasOption('n') && !argOptions.hasOption('w') || !argOptions.hasOption('t') || argOptions.numPositionalArgs() != 2) {
            PsudoWordSelector.usage(argOptions);
        }
        usePos = argOptions.hasOption('P');
        List<Map<String, Double>> list = PsudoWordSelector.loadScores(argOptions.getPositionalArg(0));
        List<Set<String>> list2 = argOptions.hasOption('w') ? PsudoWordSelector.extractWordList(argOptions.getStringOption('w')) : PsudoWordSelector.selectWord(list, argOptions.getIntOption('n'));
        String string = argOptions.getStringOption('t');
        PrintWriter printWriter = new PrintWriter(argOptions.getPositionalArg(1));
        for (int i = 0; i < list2.size(); ++i) {
            Map<String, Double> map = list.get(i);
            Set<String> set = list2.get(i);
            Map<String, String> map2 = null;
            if (string.equals("high")) {
                map2 = PsudoWordSelector.selectHigh(map, set);
            } else if (string.equals("med")) {
                map2 = PsudoWordSelector.selectMed(map, set);
            } else if (string.equals("low")) {
                map2 = PsudoWordSelector.selectLow(map, set);
            } else {
                PsudoWordSelector.usage(argOptions);
            }
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                printWriter.printf("%s %s\n", entry.getKey(), entry.getValue());
            }
        }
        printWriter.close();
    }

    public static Map<String, String> selectHigh(Map<String, Double> map, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String object2 : arrayList) {
            hashMap.put(object2, hashMap.size());
        }
        HashMap hashMap2 = new HashMap();
        Random random = new Random();
        for (String string : set) {
            int n = random.nextInt(2);
            if (n == 0) {
                --n;
            }
            PsudoWordSelector.addWord(string, n, arrayList, hashMap, hashMap2);
        }
        return hashMap2;
    }

    public static void addWord(String string, int n, List<String> list, Map<String, Integer> map, Map<String, String> map2) {
        Integer n2 = map.get(string);
        if (n2 == null) {
            return;
        }
        System.out.printf("Skipped: %s\n", string);
        n = n2 + n;
        String string2 = list.get(n);
        String string3 = string + string2;
        map2.put(string, string3);
        map2.put(string2, string3);
    }

    public static Map<String, String> selectMed(Map<String, Double> map, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String object2 : arrayList) {
            hashMap.put(object2, hashMap.size());
        }
        HashMap hashMap2 = new HashMap();
        Random random = new Random();
        for (String string : set) {
            int n = random.nextInt(200) - 100;
            if (n == 0) {
                ++n;
            }
            int n2 = (Integer)hashMap.get(string);
            n = n2 + n;
            String string2 = (String)arrayList.get(n);
            String string3 = string + string2;
            hashMap2.put(string, string3);
            hashMap2.put(string2, string3);
        }
        return hashMap2;
    }

    public static Map<String, String> selectLow(Map<String, Double> map, Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        hashSet.removeAll(set);
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.shuffle(arrayList);
        Iterator iterator = arrayList.iterator();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : set) {
            String string2 = (String)iterator.next();
            String string3 = string + string2;
            hashMap.put(string, string3);
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public static List<Map<String, Double>> loadScores(String string) throws Exception {
        ArrayList<Map<String, Double>> arrayList = new ArrayList<Map<String, Double>>();
        int n = usePos ? 3 : 1;
        for (int i = 0; i < n; ++i) {
            arrayList.add(new LinkedHashMap());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\\s+");
            int n2 = 0;
            if (usePos) {
                String[] stringArray2 = stringArray[0].split("-");
                if (stringArray2[1].startsWith("N")) {
                    n2 = 0;
                } else if (stringArray2[1].startsWith("V")) {
                    n2 = 1;
                } else if (stringArray2[1].startsWith("J")) {
                    n2 = 2;
                }
                stringArray[0] = stringArray2[0];
            }
            ((Map)arrayList.get(n2)).put(stringArray[0], Double.parseDouble(stringArray[1]));
        }
        return arrayList;
    }

    public static List<Set<String>> extractWordList(String string) throws Exception {
        ArrayList<Set<String>> arrayList = new ArrayList<Set<String>>();
        int n = usePos ? 3 : 1;
        for (int i = 0; i < n; ++i) {
            arrayList.add(new HashSet());
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (usePos) {
                String[] stringArray = string2.trim().split("-");
                if (stringArray[1].startsWith("N")) {
                    ((Set)arrayList.get(0)).add(stringArray[0]);
                    continue;
                }
                if (stringArray[1].startsWith("V")) {
                    ((Set)arrayList.get(1)).add(stringArray[0]);
                    continue;
                }
                if (!stringArray[1].startsWith("J")) continue;
                ((Set)arrayList.get(2)).add(stringArray[0]);
                continue;
            }
            ((Set)arrayList.get(0)).add(string2.trim());
        }
        return arrayList;
    }

    public static List<Set<String>> selectWord(List<Map<String, Double>> list, int n) {
        ArrayList<Set<String>> arrayList = new ArrayList<Set<String>>();
        for (Map<String, Double> map : list) {
            ArrayList<String> arrayList2 = new ArrayList<String>(map.keySet());
            Collections.shuffle(arrayList2);
            HashSet hashSet = new HashSet();
            for (int i = 0; i < n; ++i) {
                hashSet.add(arrayList2.get(i));
            }
            arrayList.add(hashSet);
        }
        return arrayList;
    }
}

