/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.tools;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.dependency.CoNLLDependencyExtractor;
import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.text.DependencyFileDocumentIterator;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.TokenFilter;
import edu.ucla.sspace.util.LoggerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class DepSemTokenCounter {
    private final Set<String> foundTokens;
    private final DependencyExtractor extractor;

    public DepSemTokenCounter(DependencyExtractor dependencyExtractor) {
        this.extractor = dependencyExtractor;
        this.foundTokens = new HashSet<String>();
    }

    public Set<String> getTokens() {
        return this.foundTokens;
    }

    private void process(Iterator<Document> iterator) throws IOException {
        long l = 0L;
        while (iterator.hasNext()) {
            int n;
            int n2;
            Document document = iterator.next();
            BufferedReader bufferedReader = document.reader();
            String string = bufferedReader.readLine();
            DependencyTreeNode[] dependencyTreeNodeArray = this.extractor.readNextTree(bufferedReader);
            for (n2 = 0; n2 < dependencyTreeNodeArray.length && !dependencyTreeNodeArray[n2].lemma().equals(string); ++n2) {
            }
            this.foundTokens.add(dependencyTreeNodeArray[n2].word().toLowerCase());
            for (n = n2 + 1; n < n2 + 10 && n < dependencyTreeNodeArray.length; ++n) {
                this.foundTokens.add(dependencyTreeNodeArray[n].word().toLowerCase());
            }
            for (n = Math.max(0, n2 - 10); n < n2; ++n) {
                this.foundTokens.add(dependencyTreeNodeArray[n].word().toLowerCase());
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('F', "tokenFilter", "filters to apply to the input token stream", true, "FILTER_SPEC", "Tokenizing Options");
        argOptions.addOption('v', "verbose", "Print verbose output about counting status", false, null, "Optional");
        argOptions.parseOptions(stringArray);
        if (argOptions.numPositionalArgs() < 2) {
            System.out.println("usage: java DepTokenCounter [options] <output-file> <input-file> [<input-file>]*\n" + argOptions.prettyPrint() + "\n\n" + "token configuration lists sets of files that contain tokens to be included or\nexcluded.  The behavior, \"include\" or \"exclude\" is specified\nfirst, followed by one or more file names, each separated by colons.\nMultiple behaviors may be specified one after the other using a ','\ncharacter to separate them.  For example, a typicaly configuration may\nlook like: include=top-tokens.txt:test-words.txt,exclude=stop-words.txt\nNote behaviors are applied in the order they are presented on the command-line.");
            return;
        }
        if (argOptions.hasOption("verbose")) {
            LoggerUtil.setLevel(Level.FINE);
        }
        TokenFilter tokenFilter = argOptions.hasOption("tokenFilter") ? TokenFilter.loadFromSpecification(argOptions.getStringOption('F')) : null;
        CoNLLDependencyExtractor coNLLDependencyExtractor = new CoNLLDependencyExtractor(tokenFilter, null);
        DepSemTokenCounter depSemTokenCounter = new DepSemTokenCounter(coNLLDependencyExtractor);
        for (int i = 1; i < argOptions.numPositionalArgs(); ++i) {
            depSemTokenCounter.process(new DependencyFileDocumentIterator(argOptions.getPositionalArg(i)));
        }
        PrintWriter printWriter = new PrintWriter(argOptions.getPositionalArg(0));
        for (String string : depSemTokenCounter.getTokens()) {
            printWriter.println(string);
        }
        printWriter.close();
    }
}

