/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringUtils {
    private static final Map<String, String> HTML_CODES = new HashMap<String, String>();
    private static final Map<String, String> LATIN1_CODES = new HashMap<String, String>();

    private StringUtils() {
    }

    public static List<String> loadFileAsList(File file) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
            return arrayList;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public static Set<String> loadFileAsSet(File file) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                hashSet.add(string);
            }
            bufferedReader.close();
            return hashSet;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public String join(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 8);
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public String join(Collection<String> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder(collection.size() * 8);
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static Set<String> loadAsSet(File file) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                hashSet.add(string);
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return hashSet;
    }

    public static final String unescapeHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        n = string.indexOf("&");
        n2 = string.indexOf(";", n);
        while (n > -1 && n2 > n) {
            String string2 = string.substring(n, n2 + 1);
            String string3 = HTML_CODES.get(string2);
            if (string3 == null) {
                string3 = LATIN1_CODES.get(string2);
            }
            if (string3 != null) {
                String string4 = string.substring(n3, n);
                stringBuilder.append(string4).append(string3);
                n3 = n2 + 1;
            }
            n = string.indexOf("&", n2);
            n2 = string.indexOf(";", n);
        }
        if (stringBuilder.length() == 0) {
            return string;
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static final void unescapeHTML(StringBuilder stringBuilder) {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        n = stringBuilder.indexOf("&");
        n2 = stringBuilder.indexOf(";", n);
        while (n > -1 && n2 > n) {
            String string = stringBuilder.substring(n, n2 + 1);
            String string2 = HTML_CODES.get(string);
            if (string2 == null) {
                string2 = LATIN1_CODES.get(string);
            }
            if (string2 != null) {
                stringBuilder.replace(n, n2 + 1, string2);
            }
            n = stringBuilder.indexOf("&", n + 1);
            n2 = stringBuilder.indexOf(";", n);
        }
    }

    static {
        HTML_CODES.put("&nbsp;", " ");
        HTML_CODES.put("&Agrave;", "\u221a\u00c4");
        HTML_CODES.put("&Aacute;", "\u221a\u00c5");
        HTML_CODES.put("&Acirc;", "\u221a\u00c7");
        HTML_CODES.put("&Atilde;", "\u221a\u00c9");
        HTML_CODES.put("&Auml;", "\u221a\u00d1");
        HTML_CODES.put("&Aring;", "\u221a\u00d6");
        HTML_CODES.put("&AElig;", "\u221a\u00dc");
        HTML_CODES.put("&Ccedil;", "\u221a\u00e1");
        HTML_CODES.put("&Egrave;", "\u221a\u00e0");
        HTML_CODES.put("&Eacute;", "\u221a\u00e2");
        HTML_CODES.put("&Ecirc;", "\u221a\u00e4");
        HTML_CODES.put("&Euml;", "\u221a\u00e3");
        HTML_CODES.put("&Igrave;", "\u221a\u00e5");
        HTML_CODES.put("&Iacute;", "\u221a\u00e7");
        HTML_CODES.put("&Icirc;", "\u221a\u00e9");
        HTML_CODES.put("&Iuml;", "\u221a\u00e8");
        HTML_CODES.put("&ETH;", "\u221a\u00ea");
        HTML_CODES.put("&Ntilde;", "\u221a\u00eb");
        HTML_CODES.put("&Ograve;", "\u221a\u00ed");
        HTML_CODES.put("&Oacute;", "\u221a\u00ec");
        HTML_CODES.put("&Ocirc;", "\u221a\u00ee");
        HTML_CODES.put("&Otilde;", "\u221a\u00ef");
        HTML_CODES.put("&Ouml;", "\u221a\u00f1");
        HTML_CODES.put("&Oslash;", "\u221a\u00f2");
        HTML_CODES.put("&Ugrave;", "\u221a\u00f4");
        HTML_CODES.put("&Uacute;", "\u221a\u00f6");
        HTML_CODES.put("&Ucirc;", "\u221a\u00f5");
        HTML_CODES.put("&Uuml;", "\u221a\u00fa");
        HTML_CODES.put("&Yacute;", "\u221a\u00f9");
        HTML_CODES.put("&THORN;", "\u221a\u00fb");
        HTML_CODES.put("&szlig;", "\u221a\u00fc");
        HTML_CODES.put("&agrave;", "\u221a\u2020");
        HTML_CODES.put("&aacute;", "\u221a\u00b0");
        HTML_CODES.put("&acirc;", "\u221a\u00a2");
        HTML_CODES.put("&atilde;", "\u221a\u00a3");
        HTML_CODES.put("&auml;", "\u221a\u00a7");
        HTML_CODES.put("&aring;", "\u221a\u2022");
        HTML_CODES.put("&aelig;", "\u221a\u00b6");
        HTML_CODES.put("&ccedil;", "\u221a\u00df");
        HTML_CODES.put("&egrave;", "\u221a\u00ae");
        HTML_CODES.put("&eacute;", "\u221a\u00a9");
        HTML_CODES.put("&ecirc;", "\u221a\u2122");
        HTML_CODES.put("&euml;", "\u221a\u00b4");
        HTML_CODES.put("&igrave;", "\u221a\u00a8");
        HTML_CODES.put("&iacute;", "\u221a\u2260");
        HTML_CODES.put("&icirc;", "\u221a\u00c6");
        HTML_CODES.put("&iuml;", "\u221a\u00d8");
        HTML_CODES.put("&eth;", "\u221a\u221e");
        HTML_CODES.put("&ntilde;", "\u221a\u00b1");
        HTML_CODES.put("&ograve;", "\u221a\u2264");
        HTML_CODES.put("&oacute;", "\u221a\u2265");
        HTML_CODES.put("&ocirc;", "\u221a\u00a5");
        HTML_CODES.put("&otilde;", "\u221a\u00b5");
        HTML_CODES.put("&ouml;", "\u221a\u2202");
        HTML_CODES.put("&oslash;", "\u221a\u220f");
        HTML_CODES.put("&ugrave;", "\u221a\u03c0");
        HTML_CODES.put("&uacute;", "\u221a\u222b");
        HTML_CODES.put("&ucirc;", "\u221a\u00aa");
        HTML_CODES.put("&uuml;", "\u221a\u00ba");
        HTML_CODES.put("&yacute;", "\u221a\u03a9");
        HTML_CODES.put("&thorn;", "\u221a\u00e6");
        HTML_CODES.put("&yuml;", "\u221a\u00f8");
        HTML_CODES.put("&lt;", "<");
        HTML_CODES.put("&gt;", ">");
        HTML_CODES.put("&quot;", "\"");
        HTML_CODES.put("&amp;", "&");
        LATIN1_CODES.put("&#039;", "'");
        LATIN1_CODES.put("&#160;", " ");
        LATIN1_CODES.put("&#162;", "\u00ac\u00a2");
        LATIN1_CODES.put("&#164;", "\u00ac\u00a7");
        LATIN1_CODES.put("&#166;", "\u00ac\u00b6");
        LATIN1_CODES.put("&#168;", "\u00ac\u00ae");
        LATIN1_CODES.put("&#170;", "\u00ac\u2122");
        LATIN1_CODES.put("&#172;", "\u00ac\u00a8");
        LATIN1_CODES.put("&#174;", "\u00ac\u00c6");
        LATIN1_CODES.put("&#176;", "\u00ac\u221e");
        LATIN1_CODES.put("&#178;", "\u00ac\u2264");
        LATIN1_CODES.put("&#180;", "\u00ac\u00a5");
        LATIN1_CODES.put("&#182;", "\u00ac\u2202");
        LATIN1_CODES.put("&#184;", "\u00ac\u220f");
        LATIN1_CODES.put("&#186;", "\u00ac\u222b");
        LATIN1_CODES.put("&#188;", "\u00ac\u00ba");
        LATIN1_CODES.put("&#190;", "\u00ac\u00e6");
        LATIN1_CODES.put("&#192;", "\u221a\u00c4");
        LATIN1_CODES.put("&#194;", "\u221a\u00c7");
        LATIN1_CODES.put("&#196;", "\u221a\u00d1");
        LATIN1_CODES.put("&#198;", "\u221a\u00dc");
        LATIN1_CODES.put("&#200;", "\u221a\u00e0");
        LATIN1_CODES.put("&#202;", "\u221a\u00e4");
        LATIN1_CODES.put("&#204;", "\u221a\u00e5");
        LATIN1_CODES.put("&#206;", "\u221a\u00e9");
        LATIN1_CODES.put("&#208;", "\u221a\u00ea");
        LATIN1_CODES.put("&#210;", "\u221a\u00ed");
        LATIN1_CODES.put("&#212;", "\u221a\u00ee");
        LATIN1_CODES.put("&#214;", "\u221a\u00f1");
        LATIN1_CODES.put("&#216;", "\u221a\u00f2");
        LATIN1_CODES.put("&#218;", "\u221a\u00f6");
        LATIN1_CODES.put("&#220;", "\u221a\u00fa");
        LATIN1_CODES.put("&#222;", "\u221a\u00fb");
        LATIN1_CODES.put("&#224;", "\u221a\u2020");
        LATIN1_CODES.put("&#226;", "\u221a\u00a2");
        LATIN1_CODES.put("&#228;", "\u221a\u00a7");
        LATIN1_CODES.put("&#230;", "\u221a\u00b6");
        LATIN1_CODES.put("&#232;", "\u221a\u00ae");
        LATIN1_CODES.put("&#234;", "\u221a\u2122");
        LATIN1_CODES.put("&#236;", "\u221a\u00a8");
        LATIN1_CODES.put("&#238;", "\u221a\u00c6");
        LATIN1_CODES.put("&#240;", "\u221a\u221e");
        LATIN1_CODES.put("&#242;", "\u221a\u2264");
        LATIN1_CODES.put("&#244;", "\u221a\u00a5");
        LATIN1_CODES.put("&#246;", "\u221a\u2202");
        LATIN1_CODES.put("&#248;", "\u221a\u220f");
        LATIN1_CODES.put("&#250;", "\u221a\u222b");
        LATIN1_CODES.put("&#252;", "\u221a\u00ba");
        LATIN1_CODES.put("&#254;", "\u221a\u00e6");
        LATIN1_CODES.put("&#34;", "\"");
        LATIN1_CODES.put("&#38;", "&");
        LATIN1_CODES.put("&#8217;", "'");
    }
}

