/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.Stemmer;
import edu.ucla.sspace.text.WordIterator;
import java.io.BufferedReader;
import java.util.Iterator;

public class StemmingIterator
implements Iterator<String> {
    private final Iterator<String> tokenizer;
    private final Stemmer stemmer;

    public StemmingIterator(String string, Stemmer stemmer) {
        this(new WordIterator(string), stemmer);
    }

    public StemmingIterator(BufferedReader bufferedReader, Stemmer stemmer) {
        this(new WordIterator(bufferedReader), stemmer);
    }

    public StemmingIterator(Iterator<String> iterator, Stemmer stemmer) {
        this.tokenizer = iterator;
        this.stemmer = stemmer;
    }

    @Override
    public boolean hasNext() {
        return this.tokenizer.hasNext();
    }

    @Override
    public String next() {
        return this.stemmer.stem(this.tokenizer.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }
}

