/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.WordIterator;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class BufferedIterator
implements Iterator<String> {
    private final Iterator<String> tokenizer;
    private final List<String> buffer;

    public BufferedIterator(String string) {
        this(new BufferedReader(new StringReader(string)));
    }

    public BufferedIterator(BufferedReader bufferedReader) {
        this(new WordIterator(bufferedReader));
    }

    public BufferedIterator(Iterator<String> iterator) {
        this.tokenizer = iterator;
        this.buffer = new LinkedList<String>();
    }

    private boolean advance(int n) {
        while (this.buffer.size() < n && this.tokenizer.hasNext()) {
            this.buffer.add(this.tokenizer.next());
        }
        return this.buffer.size() >= n;
    }

    @Override
    public boolean hasNext() {
        return this.buffer.size() > 0 || this.advance(1);
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buffer.remove(0);
    }

    public List<String> peek(int n) {
        this.advance(n);
        return new ArrayList<String>(this.buffer.subList(0, Math.min(n, this.buffer.size())));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }
}

