/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.temporal;

import edu.ucla.sspace.temporal.TemporalSemanticSpace;
import edu.ucla.sspace.temporal.TemporalSemanticSpaceUtils;
import edu.ucla.sspace.util.IntegerMap;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Logger;

public class FileBasedTemporalSemanticSpace
implements TemporalSemanticSpace {
    private static final Logger LOGGER = Logger.getLogger(FileBasedTemporalSemanticSpace.class.getName());
    private final Map<String, SemanticVector> wordToMeaning;
    private final String spaceName;
    private int dimensions;
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;

    public FileBasedTemporalSemanticSpace(String string) {
        this(new File(string), TemporalSemanticSpaceUtils.TSSpaceFormat.TEXT);
    }

    public FileBasedTemporalSemanticSpace(File file) {
        this(file, TemporalSemanticSpaceUtils.TSSpaceFormat.TEXT);
    }

    public FileBasedTemporalSemanticSpace(String string, TemporalSemanticSpaceUtils.TSSpaceFormat tSSpaceFormat) {
        this(new File(string), tSSpaceFormat);
    }

    public FileBasedTemporalSemanticSpace(File file, TemporalSemanticSpaceUtils.TSSpaceFormat tSSpaceFormat) {
        Map<String, SemanticVector> map = null;
        try {
            switch (tSSpaceFormat) {
                case TEXT: {
                    map = this.loadText(file);
                    break;
                }
                case SPARSE_TEXT: {
                    map = this.loadSparseText(file);
                    break;
                }
                case BINARY: {
                    map = this.loadBinary(file);
                    break;
                }
                case SPARSE_BINARY: {
                    map = this.loadSparseBinary(file);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unhandled format type " + (Object)((Object)tSSpaceFormat));
                }
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        this.wordToMeaning = map;
        this.spaceName = file.getName();
    }

    private Map<String, SemanticVector> loadText(File file) throws IOException {
        LOGGER.info("loading text TSS from " + file);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String[] stringArray = bufferedReader.readLine().split("\\s+");
        int n = Integer.parseInt(stringArray[0]);
        this.dimensions = Integer.parseInt(stringArray[1]);
        HashMap<String, SemanticVector> hashMap = new HashMap<String, SemanticVector>(n, 2.0f);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray2 = string.split("\\|");
            String string2 = stringArray2[0];
            SemanticVector semanticVector = new SemanticVector(this.dimensions);
            LOGGER.info("loading " + stringArray2.length + " timesteps for word " + string2);
            for (int i = 1; i < stringArray2.length; ++i) {
                String[] stringArray3 = stringArray2[i].split(" ");
                long l = Long.parseLong(stringArray3[0]);
                this.updateTimeRange(l);
                IntegerMap<Double> integerMap = new IntegerMap<Double>();
                for (int j = 1; j < stringArray3.length; ++j) {
                    integerMap.put(j - 1, Double.valueOf(stringArray3[j]));
                }
                semanticVector.setSemantics(l, integerMap);
            }
            hashMap.put(string2, semanticVector);
        }
        return hashMap;
    }

    private Map<String, SemanticVector> loadSparseText(File file) throws IOException {
        LOGGER.info("loading sparse text TSS from " + file);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String[] stringArray = bufferedReader.readLine().split("\\s+");
        int n = Integer.parseInt(stringArray[0]);
        this.dimensions = Integer.parseInt(stringArray[1]);
        HashMap<String, SemanticVector> hashMap = new HashMap<String, SemanticVector>(n, 2.0f);
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = bufferedReader.readLine().split("\\|");
            String string = stringArray2[0];
            SemanticVector semanticVector = new SemanticVector(this.dimensions);
            hashMap.put(string, semanticVector);
            LOGGER.info("loading " + stringArray2.length + " timesteps for word " + string);
            for (int j = 1; j < stringArray2.length; ++j) {
                String[] stringArray3 = stringArray2[j].split("%");
                String[] stringArray4 = stringArray3[0].split(" ");
                long l = Long.parseLong(stringArray4[0]);
                this.updateTimeRange(l);
                int n2 = Integer.parseInt(stringArray4[1]);
                String[] stringArray5 = stringArray3[1].split(",");
                IntegerMap<Double> integerMap = new IntegerMap<Double>();
                for (int k = 0; k < stringArray5.length; k += 2) {
                    Integer n3 = Integer.valueOf(stringArray5[k]);
                    Double d = Double.valueOf(stringArray5[k + 1]);
                }
                semanticVector.setSemantics(l, integerMap);
            }
        }
        return hashMap;
    }

    private Map<String, SemanticVector> loadBinary(File file) throws IOException {
        LOGGER.info("loading binary TSS from " + file);
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        int n = dataInputStream.readInt();
        this.dimensions = dataInputStream.readInt();
        HashMap<String, SemanticVector> hashMap = new HashMap<String, SemanticVector>(n, 2.0f);
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            SemanticVector semanticVector = new SemanticVector(this.dimensions);
            hashMap.put(string, semanticVector);
            LOGGER.info("loading " + n2 + " timesteps for word " + string);
            IntegerMap<Double> integerMap = new IntegerMap<Double>();
            for (int j = 0; j < n2; ++j) {
                long l = dataInputStream.readLong();
                this.updateTimeRange(l);
                for (int k = 0; k < this.dimensions; ++k) {
                    int n3 = dataInputStream.readInt();
                    double d = dataInputStream.readDouble();
                    integerMap.put(n3, Double.valueOf(d));
                }
                semanticVector.setSemantics(l, integerMap);
            }
        }
        return hashMap;
    }

    private Map<String, SemanticVector> loadSparseBinary(File file) throws IOException {
        LOGGER.info("loading text TSS from " + file);
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        int n = dataInputStream.readInt();
        this.dimensions = dataInputStream.readInt();
        HashMap<String, SemanticVector> hashMap = new HashMap<String, SemanticVector>(n, 2.0f);
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            int n2 = dataInputStream.readInt();
            SemanticVector semanticVector = new SemanticVector(this.dimensions);
            hashMap.put(string, semanticVector);
            LOGGER.info("loading " + n2 + " timesteps for word " + string);
            for (int j = 0; j < n2; ++j) {
                long l = dataInputStream.readLong();
                this.updateTimeRange(l);
                int n3 = dataInputStream.readInt();
                IntegerMap<Double> integerMap = new IntegerMap<Double>();
                for (int k = 0; k < n3; ++k) {
                    int n4 = dataInputStream.readInt();
                    double d = dataInputStream.readDouble();
                    integerMap.put(n4, Double.valueOf(d));
                }
                semanticVector.setSemantics(l, integerMap);
            }
        }
        return hashMap;
    }

    private void updateTimeRange(long l) {
        if (l < this.startTime) {
            this.startTime = l;
        }
        if (l > this.endTime) {
            this.endTime = l;
        }
    }

    @Override
    public Long startTime() {
        return this.startTime;
    }

    @Override
    public Long endTime() {
        return this.endTime;
    }

    @Override
    public Vector getVector(String string) {
        SemanticVector semanticVector = this.wordToMeaning.get(string);
        return semanticVector == null ? null : semanticVector.getVector();
    }

    @Override
    public Vector getVectorAfter(String string, long l) {
        SemanticVector semanticVector = this.wordToMeaning.get(string);
        return semanticVector == null ? null : semanticVector.getVectorAfter(l);
    }

    @Override
    public Vector getVectorBefore(String string, long l) {
        SemanticVector semanticVector = this.wordToMeaning.get(string);
        return semanticVector == null ? null : semanticVector.getVectorBefore(l);
    }

    @Override
    public Vector getVectorBetween(String string, long l, long l2) {
        SemanticVector semanticVector = this.wordToMeaning.get(string);
        return semanticVector == null ? null : semanticVector.getVectorBetween(l, l2);
    }

    @Override
    public SortedSet<Long> getTimeSteps(String string) {
        SemanticVector semanticVector = this.wordToMeaning.get(string);
        return semanticVector == null ? null : semanticVector.getTimeSteps();
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.wordToMeaning.keySet());
    }

    @Override
    public String getSpaceName() {
        return this.spaceName;
    }

    @Override
    public int getVectorLength() {
        return this.dimensions;
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) {
    }

    @Override
    public void processDocument(BufferedReader bufferedReader, long l) {
    }

    @Override
    public void processSpace(Properties properties) {
    }

    private static class SemanticVector {
        private final NavigableMap<Long, Map<Integer, Double>> timeStampToSemantics;
        private final int dimensions;

        public SemanticVector(int n) {
            this.dimensions = n;
            this.timeStampToSemantics = new TreeMap<Long, Map<Integer, Double>>();
        }

        public void setSemantics(long l, double[] dArray) {
            Long l2 = l;
            IntegerMap<Double> integerMap = new IntegerMap<Double>();
            for (int i = 0; i < dArray.length; ++i) {
                double d = dArray[i];
                if (d == 0.0) continue;
                integerMap.put(i, Double.valueOf(d));
            }
            this.timeStampToSemantics.put(l2, integerMap);
        }

        public void setSemantics(long l, Map<Integer, Double> map) {
            this.timeStampToSemantics.put(l, map);
        }

        private DoubleVector computeSemantics(Map<Long, Map<Integer, Double>> map) {
            double[] dArray = new double[this.dimensions];
            for (Map<Integer, Double> map2 : map.values()) {
                for (Map.Entry<Integer, Double> entry : map2.entrySet()) {
                    int n = entry.getKey();
                    dArray[n] = dArray[n] + (double)entry.getValue().intValue();
                }
            }
            return new DenseVector(dArray);
        }

        public long getEndTime() {
            return (Long)this.timeStampToSemantics.lastKey();
        }

        public long getStartTime() {
            return (Long)this.timeStampToSemantics.firstKey();
        }

        public SortedSet<Long> getTimeSteps() {
            return Collections.unmodifiableSortedSet(this.timeStampToSemantics.navigableKeySet());
        }

        public DoubleVector getVector() {
            return this.computeSemantics(this.timeStampToSemantics);
        }

        public Vector getVectorAfter(long l) {
            SortedMap<Long, Map<Integer, Double>> sortedMap = this.timeStampToSemantics.tailMap(l);
            return this.computeSemantics(sortedMap);
        }

        public Vector getVectorBefore(long l) {
            SortedMap<Long, Map<Integer, Double>> sortedMap = this.timeStampToSemantics.headMap(l);
            return this.computeSemantics(sortedMap);
        }

        public Vector getVectorBetween(long l, long l2) {
            SortedMap<Long, Map<Integer, Double>> sortedMap = this.timeStampToSemantics.subMap(l, l2);
            return this.computeSemantics(sortedMap);
        }
    }
}

