/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.ri;

import edu.ucla.sspace.common.Filterable;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.index.TernaryPermutationFunction;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.vector.CompactSparseIntegerVector;
import edu.ucla.sspace.vector.DenseIntVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RandomIndexing
implements SemanticSpace,
Filterable {
    public static final String RI_SSPACE_NAME = "random-indexing";
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.ri.RandomIndexing";
    public static final String VECTOR_LENGTH_PROPERTY = "edu.ucla.sspace.ri.RandomIndexing.vectorLength";
    public static final String WINDOW_SIZE_PROPERTY = "edu.ucla.sspace.ri.RandomIndexing.windowSize";
    public static final String USE_PERMUTATIONS_PROPERTY = "edu.ucla.sspace.ri.RandomIndexing.usePermutations";
    public static final String PERMUTATION_FUNCTION_PROPERTY = "edu.ucla.sspace.ri.RandomIndexing.permutationFunction";
    public static final String USE_SPARSE_SEMANTICS_PROPERTY = "edu.ucla.sspace.ri.RandomIndexing.sparseSemantics";
    public static final int DEFAULT_WINDOW_SIZE = 2;
    public static final int DEFAULT_VECTOR_LENGTH = 4000;
    static final Random RANDOM = new Random();
    private final Map<String, TernaryVector> wordToIndexVector;
    private final Map<String, IntegerVector> wordToMeaning;
    private final int vectorLength;
    private final int windowSize;
    private final boolean usePermutations;
    private final PermutationFunction<TernaryVector> permutationFunc;
    private final boolean useSparseSemantics;
    private final Set<String> semanticFilter;

    public RandomIndexing() {
        this(System.getProperties());
    }

    public RandomIndexing(Properties properties) {
        String string = properties.getProperty(VECTOR_LENGTH_PROPERTY);
        this.vectorLength = string != null ? Integer.parseInt(string) : 4000;
        String string2 = properties.getProperty(WINDOW_SIZE_PROPERTY);
        this.windowSize = string2 != null ? Integer.parseInt(string2) : 2;
        String string3 = properties.getProperty(USE_PERMUTATIONS_PROPERTY);
        this.usePermutations = string3 != null ? Boolean.parseBoolean(string3) : false;
        String string4 = properties.getProperty(PERMUTATION_FUNCTION_PROPERTY);
        this.permutationFunc = string4 != null ? RandomIndexing.loadPermutationFunction(string4) : new TernaryPermutationFunction();
        RandomIndexVectorGenerator randomIndexVectorGenerator = new RandomIndexVectorGenerator(this.vectorLength, properties);
        String string5 = properties.getProperty(USE_SPARSE_SEMANTICS_PROPERTY);
        this.useSparseSemantics = string5 != null ? Boolean.parseBoolean(string5) : true;
        this.wordToIndexVector = new GeneratorMap<TernaryVector>(randomIndexVectorGenerator);
        this.wordToMeaning = new ConcurrentHashMap<String, IntegerVector>();
        this.semanticFilter = new HashSet<String>();
    }

    private static PermutationFunction<TernaryVector> loadPermutationFunction(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return (PermutationFunction)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public void clearSemantics() {
        this.wordToMeaning.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntegerVector getSemanticVector(String string) {
        IntegerVector integerVector = this.wordToMeaning.get(string);
        if (integerVector == null) {
            RandomIndexing randomIndexing = this;
            synchronized (randomIndexing) {
                integerVector = this.wordToMeaning.get(string);
                if (integerVector == null) {
                    integerVector = this.useSparseSemantics ? new CompactSparseIntegerVector(this.vectorLength) : new DenseIntVector(this.vectorLength);
                    this.wordToMeaning.put(string, integerVector);
                }
            }
        }
        return integerVector;
    }

    @Override
    public Vector getVector(String string) {
        IntegerVector integerVector = this.wordToMeaning.get(string);
        if (integerVector == null) {
            return null;
        }
        return Vectors.immutable(integerVector);
    }

    @Override
    public String getSpaceName() {
        return "random-indexing-" + this.vectorLength + "v-" + this.windowSize + "w-" + (this.usePermutations ? this.permutationFunc.toString() : "noPermutations");
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.wordToMeaning.keySet());
    }

    public Map<String, TernaryVector> getWordToIndexVector() {
        return Collections.unmodifiableMap(this.wordToIndexVector);
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        int n;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(this.windowSize);
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>(this.windowSize);
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        String string = null;
        for (n = 0; n < this.windowSize && iterator.hasNext(); ++n) {
            arrayDeque2.offer(iterator.next());
        }
        while (!arrayDeque2.isEmpty()) {
            string = (String)arrayDeque2.remove();
            if (iterator.hasNext()) {
                String string2 = iterator.next();
                arrayDeque2.offer(string2);
            }
            int n2 = n = this.semanticFilter.isEmpty() || this.semanticFilter.contains(string) && !string.equals("") ? 1 : 0;
            if (n != 0) {
                TernaryVector ternaryVector;
                IntegerVector integerVector = this.getSemanticVector(string);
                int n3 = -arrayDeque.size();
                for (String string3 : arrayDeque) {
                    if (string3.equals("")) {
                        ++n3;
                        continue;
                    }
                    ternaryVector = this.wordToIndexVector.get(string3);
                    if (this.usePermutations) {
                        ternaryVector = this.permutationFunc.permute(ternaryVector, n3);
                        ++n3;
                    }
                    RandomIndexing.add(integerVector, ternaryVector);
                }
                n3 = 1;
                for (String string3 : arrayDeque2) {
                    if (string3.equals("")) {
                        ++n3;
                        continue;
                    }
                    ternaryVector = this.wordToIndexVector.get(string3);
                    if (this.usePermutations) {
                        ternaryVector = this.permutationFunc.permute(ternaryVector, n3);
                        ++n3;
                    }
                    RandomIndexing.add(integerVector, ternaryVector);
                }
            }
            arrayDeque.offer(string);
            if (arrayDeque.size() <= this.windowSize) continue;
            arrayDeque.remove();
        }
        bufferedReader.close();
    }

    @Override
    public void processSpace(Properties properties) {
    }

    public void setWordToIndexVector(Map<String, TernaryVector> map) {
        this.wordToIndexVector.clear();
        this.wordToIndexVector.putAll(map);
    }

    @Override
    public void setSemanticFilter(Set<String> set) {
        this.semanticFilter.clear();
        this.semanticFilter.addAll(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(IntegerVector integerVector, TernaryVector ternaryVector) {
        IntegerVector integerVector2 = integerVector;
        synchronized (integerVector2) {
            for (int n : ternaryVector.positiveDimensions()) {
                integerVector.add(n, 1);
            }
            for (int n : ternaryVector.negativeDimensions()) {
                integerVector.add(n, -1);
            }
        }
    }
}

