/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.SimpleEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SvdlibcSparseTextFileIterator
implements Iterator<MatrixEntry> {
    private final BufferedReader reader;
    private MatrixEntry next;
    private int rows;
    private int cols;
    private int curNonZeros;
    private int curCol;

    public SvdlibcSparseTextFileIterator(File file) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
        String[] stringArray = this.reader.readLine().split("\\s");
        this.rows = Integer.parseInt(stringArray[0]);
        this.cols = Integer.parseInt(stringArray[1]);
        this.curCol = 0;
        this.curNonZeros = Integer.parseInt(this.reader.readLine());
        this.next = this.advance();
    }

    private MatrixEntry advance() throws IOException {
        if (this.curCol >= this.cols) {
            return null;
        }
        if (this.curNonZeros == 0) {
            ++this.curCol;
            if (this.curCol >= this.cols) {
                this.reader.close();
                return null;
            }
            this.curNonZeros = Integer.parseInt(this.reader.readLine());
        }
        String[] stringArray = this.reader.readLine().split("\\s+");
        --this.curNonZeros;
        return new SimpleEntry(Integer.parseInt(stringArray[0]), this.curCol, Double.parseDouble(stringArray[1]));
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MatrixEntry next() {
        if (this.next == null) {
            throw new NoSuchElementException("No futher entries");
        }
        MatrixEntry matrixEntry = this.next;
        try {
            this.next = this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return matrixEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from file");
    }
}

