/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SvdlibcSparseBinaryFileRowIterator
implements Iterator<SparseDoubleVector> {
    private final ByteBuffer data;
    private SparseDoubleVector next;
    private int entry;
    private int nzEntriesInMatrix;
    private int curCol;
    private final int rows;
    private final int cols;

    public SvdlibcSparseBinaryFileRowIterator(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = randomAccessFile.getChannel();
        this.data = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        fileChannel.close();
        this.rows = this.data.getInt();
        this.cols = this.data.getInt();
        this.nzEntriesInMatrix = this.data.getInt();
        this.curCol = 0;
        this.entry = 0;
        this.advance();
    }

    private void advance() throws IOException {
        if (this.entry >= this.nzEntriesInMatrix) {
            this.next = null;
        } else {
            this.next = new SparseHashDoubleVector(this.rows);
            int n = this.data.getInt();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.data.getInt();
                double d = this.data.getFloat();
                this.next.set(n3, d);
                ++n2;
                ++this.entry;
            }
            ++this.curCol;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public SparseDoubleVector next() {
        if (this.next == null) {
            throw new NoSuchElementException("No futher entries");
        }
        SparseDoubleVector sparseDoubleVector = this.next;
        try {
            this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return sparseDoubleVector;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from file");
    }

    public void reset() {
        this.data.rewind();
        this.data.getInt();
        this.data.getInt();
        this.data.getInt();
        this.curCol = 0;
        this.entry = 0;
        try {
            this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }
}

