/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.SimpleEntry;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SvdlibcDenseBinaryFileIterator
implements Iterator<MatrixEntry> {
    private final DataInputStream dis;
    private MatrixEntry next;
    private int rows;
    private int cols;
    private int curCol;
    private int curRow;

    public SvdlibcDenseBinaryFileIterator(File file) throws IOException {
        this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        this.rows = this.dis.readInt();
        this.cols = this.dis.readInt();
        this.curCol = 0;
        this.curRow = 0;
        this.next = this.advance();
    }

    private MatrixEntry advance() throws IOException {
        if (this.curRow >= this.rows) {
            return null;
        }
        if (this.curCol >= this.cols) {
            this.curCol = 0;
            ++this.curRow;
        }
        if (this.curRow >= this.rows) {
            this.dis.close();
            return null;
        }
        return new SimpleEntry(this.curRow, this.curCol++, this.dis.readFloat());
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MatrixEntry next() {
        if (this.next == null) {
            throw new NoSuchElementException("No futher entries");
        }
        MatrixEntry matrixEntry = this.next;
        try {
            this.next = this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return matrixEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from file");
    }
}

