/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.AbstractMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import edu.ucla.sspace.vector.Vectors;

public class SparseHashMatrix
extends AbstractMatrix
implements SparseMatrix {
    private final int rows;
    private final int columns;
    private final SparseHashDoubleVector[] sparseMatrix;

    public SparseHashMatrix(int n, int n2) {
        this.rows = n;
        this.columns = n2;
        this.sparseMatrix = new SparseHashDoubleVector[n];
        for (int i = 0; i < n; ++i) {
            this.sparseMatrix[i] = new SparseHashDoubleVector(n2);
        }
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.rows || n2 >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(this.rows);
        for (int i = 0; i < this.rows(); ++i) {
            sparseHashDoubleVector.set(i, this.getRowVector(i).get(n));
        }
        return sparseHashDoubleVector;
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        return Vectors.immutable(this.sparseMatrix[n]);
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public void set(int n, int n2, double d) {
        this.checkIndices(n, n2);
        this.sparseMatrix[n].set(n2, d);
    }
}

