/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.BaseTransform;
import edu.ucla.sspace.matrix.GlobalTransform;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import java.io.File;

public class RowMagnitudeTransform
extends BaseTransform {
    @Override
    protected GlobalTransform getTransform(Matrix matrix) {
        return new RowMagnitudeGlobalTransform(matrix);
    }

    @Override
    protected GlobalTransform getTransform(File file, MatrixIO.Format format) {
        return new RowMagnitudeGlobalTransform(file, format);
    }

    public String toString() {
        return "TF-IDF";
    }

    public class RowMagnitudeGlobalTransform
    implements GlobalTransform {
        private double[] rowMagnitudes;

        public RowMagnitudeGlobalTransform(Matrix matrix) {
            this.rowMagnitudes = new double[matrix.rows()];
            for (int i = 0; i < matrix.rows(); ++i) {
                this.rowMagnitudes[i] = matrix.getRowVector(i).magnitude();
            }
        }

        public RowMagnitudeGlobalTransform(File file, MatrixIO.Format format) {
        }

        @Override
        public double transform(int n, int n2, double d) {
            return d / this.rowMagnitudes[n];
        }
    }
}

