/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.util.BoundedSortedMultiMap;
import edu.ucla.sspace.util.MultiMap;
import edu.ucla.sspace.util.SortedMultiMap;
import edu.ucla.sspace.util.WorkerThread;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;

public class RowComparator {
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();

    public RowComparator() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public RowComparator(int n) {
        for (int i = 0; i < n; ++i) {
            new WorkerThread(this.workQueue).start();
        }
    }

    public SortedMultiMap<Double, Integer> getMostSimilar(Matrix matrix, int n, int n2, Similarity.SimType simType) {
        BoundedSortedMultiMap<Double, Integer> boundedSortedMultiMap;
        block3: {
            boundedSortedMultiMap = new BoundedSortedMultiMap<Double, Integer>(n2, false);
            Semaphore semaphore = new Semaphore(0);
            int n3 = matrix.rows();
            DoubleVector doubleVector = matrix.getRowVector(n);
            for (int i = 0; i < n3; ++i) {
                if (i == n) continue;
                this.workQueue.offer(new Comparison(semaphore, matrix, doubleVector, i, simType, boundedSortedMultiMap));
            }
            try {
                semaphore.acquire(n3 - 1);
            }
            catch (InterruptedException interruptedException) {
                if (semaphore.availablePermits() >= 1) break block3;
                throw new IllegalStateException("interrupted while waiting for word comparisons to finish", interruptedException);
            }
        }
        return boundedSortedMultiMap;
    }

    private static class Comparison
    implements Runnable {
        private final Semaphore semaphore;
        private final Matrix m;
        private final Vector row;
        private final int otherRow;
        private final Similarity.SimType similarityMeasure;
        private final MultiMap<Double, Integer> mostSimilar;

        public Comparison(Semaphore semaphore, Matrix matrix, Vector vector, int n, Similarity.SimType simType, MultiMap<Double, Integer> multiMap) {
            this.semaphore = semaphore;
            this.m = matrix;
            this.row = vector;
            this.otherRow = n;
            this.similarityMeasure = simType;
            this.mostSimilar = multiMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Double d = Similarity.getSimilarity(this.similarityMeasure, this.row, this.m.getRowVector(this.otherRow));
                MultiMap<Double, Integer> multiMap = this.mostSimilar;
                synchronized (multiMap) {
                    this.mostSimilar.put(d, this.otherRow);
                }
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
            finally {
                this.semaphore.release();
            }
        }
    }
}

