/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.MatrixIO;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;

public class MatrixFile
implements Iterable<MatrixEntry> {
    private final File matrixFile;
    private final MatrixIO.Format format;

    public MatrixFile(File file, MatrixIO.Format format) {
        if (file == null) {
            throw new NullPointerException("matrix file cannot be null");
        }
        this.matrixFile = file;
        this.format = format;
    }

    public boolean equals(Object object) {
        if (object instanceof MatrixFile) {
            MatrixFile matrixFile = (MatrixFile)object;
            return this.matrixFile.equals(matrixFile.matrixFile) && this.format.equals((Object)matrixFile.format);
        }
        return false;
    }

    public File getFile() {
        return this.matrixFile;
    }

    public MatrixIO.Format getFormat() {
        return this.format;
    }

    public int hashCode() {
        return this.matrixFile.hashCode() ^ this.format.hashCode();
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        try {
            return MatrixIO.getMatrixFileIterator(this.matrixFile, this.format);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public Matrix load() {
        try {
            return MatrixIO.readMatrix(this.matrixFile, this.format);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public String toString() {
        return "Matrix[" + this.matrixFile + ":" + (Object)((Object)this.format) + "]";
    }
}

