/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.BaseTransform;
import edu.ucla.sspace.matrix.GlobalTransform;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.TransformStatistics;
import java.io.File;

public class LogLikelihoodTransform
extends BaseTransform {
    @Override
    protected GlobalTransform getTransform(Matrix matrix) {
        return new LogLikelihoodGlobalTransform(matrix);
    }

    @Override
    protected GlobalTransform getTransform(File file, MatrixIO.Format format) {
        return new LogLikelihoodGlobalTransform(file, format);
    }

    public String toString() {
        return "LogLikelihood";
    }

    public class LogLikelihoodGlobalTransform
    implements GlobalTransform {
        private double[] rowCounts;
        private double[] colCounts;
        private double matrixSum;

        public LogLikelihoodGlobalTransform(Matrix matrix) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(matrix);
            this.rowCounts = matrixStatistics.rowSums;
            this.colCounts = matrixStatistics.columnSums;
            this.matrixSum = matrixStatistics.matrixSum;
        }

        public LogLikelihoodGlobalTransform(File file, MatrixIO.Format format) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(file, format);
            this.rowCounts = matrixStatistics.rowSums;
            this.colCounts = matrixStatistics.columnSums;
            this.matrixSum = matrixStatistics.matrixSum;
        }

        @Override
        public double transform(int n, int n2, double d) {
            double d2 = this.colCounts[n2] - d;
            double d3 = this.rowCounts[n] - d;
            double d4 = this.matrixSum - (d + d2 + d3);
            double d5 = d * Math.log(d) + d2 * Math.log(d2) + d3 * Math.log(d3) + d4 * Math.log(d4);
            d5 -= (d + d2) * Math.log(d + d2) - (d + d3) * Math.log(d + d3);
            d5 -= (d2 + d4) * Math.log(d2 + d4) - (d3 + d4) * Math.log(d3 + d4);
            return 2.0 * (d5 += (d + d2 + d3 + d4) * Math.log(d + d2 + d3 + d4));
        }
    }
}

