/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;

public class DiagonalMatrix
implements SparseMatrix {
    private double[] values;

    public DiagonalMatrix(int n) {
        this.values = new double[n];
    }

    public DiagonalMatrix(double[] dArray) {
        this.values = new double[dArray.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = dArray[i];
        }
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.values.length || n2 >= this.values.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public double get(int n, int n2) {
        this.checkIndices(n, n2);
        if (n == n2) {
            return this.values[n];
        }
        return 0.0;
    }

    @Override
    public double[] getColumn(int n) {
        this.checkIndices(0, n);
        double[] dArray = new double[this.values.length];
        dArray[n] = this.values[n];
        return dArray;
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        this.checkIndices(0, n);
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(this.values.length);
        sparseHashDoubleVector.set(n, this.values[n]);
        return sparseHashDoubleVector;
    }

    @Override
    public double[] getRow(int n) {
        this.checkIndices(n, 0);
        double[] dArray = new double[this.values.length];
        dArray[n] = this.values[n];
        return dArray;
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        this.checkIndices(n, 0);
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(this.values.length);
        sparseHashDoubleVector.set(n, this.values[n]);
        return sparseHashDoubleVector;
    }

    @Override
    public int columns() {
        return this.values.length;
    }

    @Override
    public void set(int n, int n2, double d) {
        this.checkIndices(n, n2);
        if (n != n2) {
            throw new IllegalArgumentException("cannot set non-diagonal elements in a DiagonalMatrix");
        }
        this.values[n] = d;
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        this.checkIndices(dArray.length - 1, n);
        dArray[n] = dArray[n];
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        this.checkIndices(doubleVector.length() - 1, n);
        this.values[n] = doubleVector.get(n);
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.checkIndices(n, dArray.length - 1);
        dArray[n] = dArray[n];
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        this.checkIndices(n, doubleVector.length() - 1);
        this.values[n] = doubleVector.get(n);
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.values.length][this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            dArray[i][i] = this.values[i];
        }
        return dArray;
    }

    @Override
    public int rows() {
        return this.values.length;
    }
}

