/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.BaseTransform;
import edu.ucla.sspace.matrix.GlobalTransform;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.TransformStatistics;
import java.io.File;

public class CorrelationTransform
extends BaseTransform {
    @Override
    protected GlobalTransform getTransform(File file, MatrixIO.Format format) {
        return new CorrelationGlobalTransform(file, format);
    }

    @Override
    protected GlobalTransform getTransform(Matrix matrix) {
        return new CorrelationGlobalTransform(matrix);
    }

    public String toString() {
        return "Correlation";
    }

    public class CorrelationGlobalTransform
    implements GlobalTransform {
        private double[] rowSums;
        private double[] colSums;
        private double totalSum;

        public CorrelationGlobalTransform(Matrix matrix) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(matrix);
            this.rowSums = matrixStatistics.rowSums;
            this.colSums = matrixStatistics.columnSums;
            this.totalSum = matrixStatistics.matrixSum;
        }

        public CorrelationGlobalTransform(File file, MatrixIO.Format format) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(file, format);
            this.rowSums = matrixStatistics.rowSums;
            this.colSums = matrixStatistics.columnSums;
            this.totalSum = matrixStatistics.matrixSum;
        }

        @Override
        public double transform(int n, int n2, double d) {
            if (d == 0.0) {
                return 0.0;
            }
            double d2 = (this.totalSum * d - this.rowSums[n] * this.colSums[n2]) / Math.sqrt(this.rowSums[n] * (this.totalSum - this.rowSums[n]) * this.colSums[n2] * (this.totalSum - this.colSums[n2]));
            return d2 > 0.0 ? Math.sqrt(d2) : 0.0;
        }
    }
}

