/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.util.SparseArray;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Logger;

public class ClutoSparseMatrixBuilder
implements MatrixBuilder {
    private static final Logger LOGGER = Logger.getLogger(ClutoSparseMatrixBuilder.class.getName());
    private final File matrixFile;
    private final PrintWriter writer;
    private boolean isFinished;
    private int curRow;
    private int numCols;
    private int nonZeroValues;

    public ClutoSparseMatrixBuilder() {
        this(ClutoSparseMatrixBuilder.getTempMatrixFile());
    }

    public ClutoSparseMatrixBuilder(File file) {
        this.matrixFile = file;
        this.curRow = 0;
        this.numCols = 0;
        this.nonZeroValues = 0;
        this.isFinished = false;
        try {
            this.writer = new PrintWriter(file);
            char[] cArray = new char[100];
            Arrays.fill(cArray, ' ');
            this.writer.println(cArray);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static File getTempMatrixFile() {
        File file = null;
        try {
            file = File.createTempFile("cluto-sparse-matrix", ".dat");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return file;
    }

    @Override
    public synchronized int addColumn(double[] dArray) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (dArray.length > this.numCols) {
            this.numCols = dArray.length;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            stringBuilder.append(i + 1).append(" ").append(dArray[i]).append(" ");
            ++n;
        }
        this.writer.println(stringBuilder.toString());
        this.nonZeroValues += n;
        return ++this.curRow;
    }

    @Override
    public synchronized int addColumn(SparseArray<? extends Number> sparseArray) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (sparseArray.length() > this.numCols) {
            this.numCols = sparseArray.length();
        }
        assert (sparseArray.length() != Integer.MAX_VALUE) : "adding a column whose length is Integer.MAX_VALUE (was likley left unspecified in the  constructor).";
        int[] nArray = sparseArray.getElementIndices();
        this.nonZeroValues += nArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(n + 1).append(" ");
            stringBuilder.append(sparseArray.get(n).floatValue()).append(" ");
        }
        this.writer.println(stringBuilder.toString());
        return ++this.curRow;
    }

    @Override
    public synchronized int addColumn(Vector vector) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (vector.length() > this.numCols) {
            this.numCols = vector.length();
        }
        assert (vector.length() != Integer.MAX_VALUE) : "adding a column whose length is Integer.MAX_VALUE (was likley left unspecified in the  constructor).";
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            int[] nArray = sparseVector.getNonZeroIndices();
            this.nonZeroValues += nArray.length;
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : nArray) {
                stringBuilder.append(n + 1).append(" ");
                stringBuilder.append(vector.getValue(n).doubleValue()).append(" ");
            }
            this.writer.println(stringBuilder.toString());
        } else {
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < vector.length(); ++i) {
                double d = vector.getValue(i).doubleValue();
                if (d == 0.0) continue;
                stringBuilder.append(i + 1).append(" ").append(d).append(" ");
                ++n;
            }
            this.writer.println(stringBuilder.toString());
            this.nonZeroValues += n;
        }
        return ++this.curRow;
    }

    @Override
    public synchronized void finish() {
        if (!this.isFinished) {
            this.isFinished = true;
            try {
                this.writer.close();
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.matrixFile, "rw");
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.curRow).append(" ");
                stringBuilder.append(this.numCols).append(" ");
                stringBuilder.append(this.nonZeroValues).append(" ");
                randomAccessFile.write(stringBuilder.toString().getBytes());
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }
    }

    @Override
    public synchronized File getFile() {
        if (!this.isFinished) {
            throw new IllegalStateException("Cannot access matrix file until finished has been called");
        }
        return this.matrixFile;
    }

    @Override
    public MatrixIO.Format getMatrixFormat() {
        return MatrixIO.Format.CLUTO_SPARSE;
    }

    @Override
    public MatrixFile getMatrixFile() {
        return new MatrixFile(this.getFile(), this.getMatrixFormat());
    }

    @Override
    public synchronized boolean isFinished() {
        return this.isFinished;
    }
}

