/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.AtomicMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicGrowingSparseHashMatrix
implements AtomicMatrix,
SparseMatrix {
    private final ConcurrentMap<Entry, Object> lockedEntries;
    private final ConcurrentMap<Entry, Double> matrixEntries;
    private final AtomicInteger rows = new AtomicInteger(0);
    private final AtomicInteger cols = new AtomicInteger(0);
    private final AtomicInteger modifications = new AtomicInteger(0);
    private final AtomicInteger lastVectorCacheUpdate = new AtomicInteger(0);
    private int[][] rowToColsCache = null;
    private int[][] colToRowsCache = null;

    public AtomicGrowingSparseHashMatrix() {
        int n = Runtime.getRuntime().availableProcessors();
        this.lockedEntries = new ConcurrentHashMap<Entry, Object>(1000, 0.75f, n * 16);
        this.matrixEntries = new ConcurrentHashMap<Entry, Double>(10000, 4.0f, n * 16);
    }

    @Override
    public double addAndGet(int n, int n2, double d) {
        double d2;
        this.checkIndices(n, n2, true);
        Entry entry = new Entry(n, n2);
        while (this.lockedEntries.putIfAbsent(entry, new Object()) != null) {
        }
        Double d3 = (Double)this.matrixEntries.get(entry);
        double d4 = d2 = d3 == null ? d : d + d3;
        if (d2 != 0.0) {
            this.matrixEntries.put(entry, d2);
            if (d3 == null) {
                this.modifications.incrementAndGet();
            }
        } else {
            this.matrixEntries.remove(entry);
            this.modifications.incrementAndGet();
        }
        this.lockedEntries.remove(entry);
        return d2;
    }

    private void checkIndices(int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (bl) {
            int n3 = n + 1;
            int n4 = 0;
            while (n3 > (n4 = this.rows.get()) && !this.rows.compareAndSet(n4, n3)) {
            }
            int n5 = n2 + 1;
            n4 = 0;
            while (n5 > (n4 = this.cols.get()) && !this.cols.compareAndSet(n4, n5)) {
            }
        }
    }

    @Override
    public int columns() {
        return this.cols.get();
    }

    @Override
    public double get(int n, int n2) {
        this.checkIndices(n, n2, false);
        Double d = (Double)this.matrixEntries.get(new Entry(n, n2));
        return d == null ? 0.0 : d;
    }

    @Override
    public double getAndAdd(int n, int n2, double d) {
        double d2;
        this.checkIndices(n, n2, true);
        Entry entry = new Entry(n, n2);
        while (this.lockedEntries.putIfAbsent(entry, new Object()) != null) {
        }
        Double d3 = (Double)this.matrixEntries.get(entry);
        double d4 = d2 = d3 == null ? d : d + d3;
        if (d2 != 0.0) {
            this.matrixEntries.put(entry, d2);
            if (d3 == null) {
                this.modifications.incrementAndGet();
            }
        } else {
            this.matrixEntries.remove(entry);
            this.modifications.incrementAndGet();
        }
        this.lockedEntries.remove(entry);
        return d3 == null ? 0.0 : d3;
    }

    @Override
    public double[] getColumn(int n) {
        return this.getColumnVector(n).toArray();
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        return this.getColumnVector(n, true);
    }

    public SparseDoubleVector getColumnVectorUnsafe(int n) {
        return this.getColumnVector(n, false);
    }

    private SparseDoubleVector getColumnVector(int n, boolean bl) {
        int n2 = this.rows.get();
        if (bl) {
            this.lockColumn(n, n2);
        }
        while (this.lastVectorCacheUpdate.get() != this.modifications.get()) {
            this.updateVectorCache();
        }
        int[] nArray = this.colToRowsCache[n];
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(n2);
        for (int n3 : nArray) {
            sparseHashDoubleVector.set(n3, (Number)this.matrixEntries.get(new Entry(n3, n)));
        }
        if (bl) {
            this.unlockColumn(n, n2);
        }
        return sparseHashDoubleVector;
    }

    @Override
    public double[] getRow(int n) {
        return this.getRowVector(n).toArray();
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        return this.getRowVector(n, true);
    }

    public SparseDoubleVector getRowVectorUnsafe(int n) {
        return this.getRowVector(n, false);
    }

    private SparseDoubleVector getRowVector(int n, boolean bl) {
        int n2 = this.cols.get();
        if (bl) {
            this.lockRow(n, n2);
        }
        while (this.lastVectorCacheUpdate.get() != this.modifications.get()) {
            this.updateVectorCache();
        }
        int[] nArray = this.rowToColsCache[n];
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(n2);
        for (int n3 : nArray) {
            sparseHashDoubleVector.set(n3, (Number)this.matrixEntries.get(new Entry(n, n3)));
        }
        if (bl) {
            this.unlockRow(n, n2);
        }
        return sparseHashDoubleVector;
    }

    private void lockRow(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            Entry entry = new Entry(n, i);
            while (this.lockedEntries.putIfAbsent(entry, new Object()) != null) {
            }
        }
    }

    private void lockColumn(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            Entry entry = new Entry(i, n);
            while (this.lockedEntries.putIfAbsent(entry, new Object()) != null) {
            }
        }
    }

    @Override
    public int rows() {
        return this.rows.get();
    }

    @Override
    public void set(int n, int n2, double d) {
        this.checkIndices(n, n2, true);
        Entry entry = new Entry(n, n2);
        while (this.lockedEntries.putIfAbsent(entry, new Object()) != null) {
        }
        boolean bl = this.matrixEntries.containsKey(entry);
        if (d != 0.0) {
            this.matrixEntries.put(entry, d);
            if (!bl) {
                this.modifications.incrementAndGet();
            }
        } else if (bl) {
            this.matrixEntries.remove(entry);
            this.modifications.incrementAndGet();
        }
        this.lockedEntries.remove(entry);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        this.setColumn(n, Vectors.asVector(dArray));
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        this.checkIndices(doubleVector.length(), n, true);
        int n2 = this.rows.get();
        this.lockColumn(n, n2);
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            double d = doubleVector.get(i);
            Entry entry = new Entry(i, n);
            boolean bl2 = this.matrixEntries.containsKey(entry);
            if (d != 0.0) {
                this.matrixEntries.put(entry, d);
                bl = bl || !bl2;
                continue;
            }
            if (!bl2) continue;
            this.matrixEntries.remove(entry);
            bl = true;
        }
        if (bl) {
            this.modifications.incrementAndGet();
        }
        this.unlockColumn(n, n2);
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.setRow(n, Vectors.asVector(dArray));
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        this.checkIndices(n, doubleVector.length(), true);
        int n2 = this.cols.get();
        this.lockRow(n, n2);
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            double d = doubleVector.get(i);
            Entry entry = new Entry(n, i);
            boolean bl2 = this.matrixEntries.containsKey(entry);
            if (d != 0.0) {
                this.matrixEntries.put(entry, d);
                bl = bl || !bl2;
                continue;
            }
            if (!bl2) continue;
            this.matrixEntries.remove(entry);
            bl = true;
        }
        if (bl) {
            this.modifications.incrementAndGet();
        }
        this.unlockRow(n, n2);
    }

    @Override
    public double[][] toDenseArray() {
        int n;
        int n2 = this.rows.get();
        int n3 = this.cols.get();
        for (int i = 0; i < n2; ++i) {
            this.lockRow(i, n3);
        }
        double[][] dArray = new double[n2][0];
        for (n = 0; n < n2; ++n) {
            DoubleVector doubleVector = this.getRowVector(n);
            if (doubleVector.length() != n3) {
                doubleVector = Vectors.subview(doubleVector, 0, n3);
            }
            dArray[n] = doubleVector.toArray();
        }
        for (n = 0; n < n2; ++n) {
            this.unlockRow(n, n3);
        }
        return dArray;
    }

    private void unlockColumn(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.lockedEntries.remove(new Entry(i, n));
        }
    }

    private void unlockRow(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.lockedEntries.remove(new Entry(n, i));
        }
    }

    private synchronized void updateVectorCache() {
        while (this.lastVectorCacheUpdate.get() != this.modifications.get()) {
            ArrayList<Integer> arrayList;
            int n;
            this.lastVectorCacheUpdate.set(this.modifications.get());
            HashMap<Integer, ArrayList<Integer>> hashMap = new HashMap<Integer, ArrayList<Integer>>();
            HashMap<Integer, ArrayList<Integer>> hashMap2 = new HashMap<Integer, ArrayList<Integer>>();
            for (Entry entry : this.matrixEntries.keySet()) {
                n = entry.row;
                int n2 = entry.col;
                arrayList = (ArrayList<Integer>)hashMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                    hashMap.put(n, arrayList);
                }
                arrayList.add(n2);
                ArrayList<Integer> arrayList2 = (ArrayList<Integer>)hashMap2.get(n2);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Integer>();
                    hashMap2.put(n2, arrayList2);
                }
                arrayList2.add(n);
            }
            this.rowToColsCache = new int[this.rows.get()][0];
            for (Map.Entry entry : hashMap.entrySet()) {
                n = (Integer)entry.getKey();
                List list = (List)entry.getValue();
                arrayList = (ArrayList<Integer>)new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    arrayList[i] = (Integer)list.get(i);
                }
                this.rowToColsCache[n] = (int[])arrayList;
                entry.setValue(null);
            }
            hashMap = null;
            this.colToRowsCache = new int[this.cols.get()][0];
            for (Map.Entry entry : hashMap2.entrySet()) {
                n = (Integer)entry.getKey();
                List list = (List)entry.getValue();
                arrayList = (ArrayList<Integer>)new int[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    arrayList[i] = (Integer)list.get(i);
                }
                this.colToRowsCache[n] = (int[])arrayList;
                entry.setValue(null);
            }
        }
    }

    private static class Entry {
        final int row;
        final int col;

        public Entry(int n, int n2) {
            this.row = n;
            this.col = n2;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return entry.row == this.row && entry.col == this.col;
            }
            return false;
        }

        public int hashCode() {
            return this.row << 16 ^ this.col;
        }
    }
}

