/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.hal.LinearWeighting;
import edu.ucla.sspace.hal.WeightingFunction;
import edu.ucla.sspace.mains.GenericWordsiMain;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.WordOccrrenceContextGenerator;

public class WCWordsiMain
extends GenericWordsiMain {
    private BasisMapping<String, String> basis;
    private WeightingFunction weighting;

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.addOption('G', "weightingFunction", "Specifies the class that will weight co-occurrences based on the window distance. (Default: LinearWeighting)", true, "CLASSNAME", "Optional");
    }

    @Override
    protected void handleExtraOptions() {
        this.weighting = this.argOptions.hasOption('G') ? (WeightingFunction)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption('G')) : new LinearWeighting();
        this.basis = this.argOptions.hasOption('L') ? (BasisMapping)this.loadObject(this.openLoadFile()) : new StringBasisMapping();
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption('S')) {
            this.saveObject(this.openSaveFile(), this.basis);
        }
    }

    @Override
    protected ContextExtractor getExtractor() {
        WordOccrrenceContextGenerator wordOccrrenceContextGenerator = new WordOccrrenceContextGenerator(this.basis, this.weighting, this.windowSize());
        return this.contextExtractorFromGenerator(wordOccrrenceContextGenerator);
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    public static void main(String[] stringArray) throws Exception {
        WCWordsiMain wCWordsiMain = new WCWordsiMain();
        wCWordsiMain.run(stringArray);
    }
}

