/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.gws.GenericWordSpace;
import edu.ucla.sspace.mains.GenericMain;
import java.util.Properties;

public class GwsMain
extends GenericMain {
    private GwsMain() {
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('s', "windowSize", "The number of words to inspect to the left and right of a focus word (default: 5)", true, "INT", "Algorithm Options");
        argOptions.addOption('W', "useWordOrder", "Distinguish between relative positions of co-occurrences of the same word (default: false)", false, null, "Algorithm Options");
    }

    public static void main(String[] stringArray) {
        GwsMain gwsMain = new GwsMain();
        try {
            gwsMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    @Override
    protected SemanticSpace getSpace() {
        return new GenericWordSpace();
    }

    @Override
    protected Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("windowSize")) {
            properties.setProperty("edu.ucla.sspace.gws.GenericWordSpace.windowSize", this.argOptions.getStringOption("windowSize"));
        }
        if (this.argOptions.hasOption("useWordOrder")) {
            properties.setProperty("edu.ucla.sspace.gws.GenericWordSpace.useWordOrder", "true");
        }
        return properties;
    }
}

