/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.grefenstette.Grefenstette;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.OneLinePerDocumentIterator;
import edu.ucla.sspace.util.CombinedIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class GrefenstetteMain
extends GenericMain {
    private Properties props;

    private GrefenstetteMain() {
    }

    @Override
    protected ArgOptions setupOptions() {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('s', "sentenceFile", "a file where each line is a sentence", true, "FILE[,FILE...]", "Required (at least one of)");
        argOptions.addOption('o', "outputFormat", "the .sspace format to use", true, "{text|binary}", "Program Options");
        argOptions.addOption('w', "overwrite", "specifies whether to overwrite the existing output", true, "BOOL", "Program Options");
        argOptions.addOption('t', "threads", "the number of threads to use", true, "INT", "Program Options");
        argOptions.addOption('v', "verbose", "prints verbose output", false, null, "Program Options");
        this.addExtraOptions(argOptions);
        return argOptions;
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
    }

    @Override
    protected Iterator<Document> getDocumentIterator() throws IOException {
        String[] stringArray;
        String string;
        CombinedIterator<Document> combinedIterator = null;
        String string2 = string = this.argOptions.hasOption("sentenceFile") ? this.argOptions.getStringOption("sentenceFile") : null;
        if (string == null) {
            throw new Error("must specify sentence file");
        }
        LinkedList linkedList = new LinkedList();
        for (String string3 : stringArray = string.split(",")) {
            linkedList.add(new OneLinePerDocumentIterator(string3));
        }
        combinedIterator = new CombinedIterator<Document>(linkedList);
        return combinedIterator;
    }

    @Override
    public SemanticSpace getSpace() {
        return new Grefenstette();
    }

    public static void main(String[] stringArray) {
        try {
            GrefenstetteMain grefenstetteMain = new GrefenstetteMain();
            grefenstetteMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

