/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.dv.DependencyVectorSpace;
import edu.ucla.sspace.mains.DependencyGenericMain;
import java.util.Properties;

public class DependencyVectorSpaceMain
extends DependencyGenericMain {
    private DependencyVectorSpaceMain() {
    }

    @Override
    public void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.addOption('a', "pathAcceptor", "the DependencyPathAcceptor to filter relations", true, "CLASSNAME", "Algorithm Options");
        argOptions.addOption('W', "pathWeighter", "the DependencyPathWeight to weight parse tree paths", true, "CLASSNAME", "Algorithm Options");
        argOptions.addOption('b', "basisMapping", "the BasisMapping to decide the dimension representations", true, "CLASSNAME", "Algorithm Options");
        argOptions.addOption('l', "pathLength", "the maximum path length that will be accepted (default: any).", true, "INT", "Algorithm Options");
    }

    public static void main(String[] stringArray) {
        DependencyVectorSpaceMain dependencyVectorSpaceMain = new DependencyVectorSpaceMain();
        try {
            dependencyVectorSpaceMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    @Override
    protected SemanticSpace getSpace() {
        this.setupDependencyExtractor();
        return new DependencyVectorSpace(System.getProperties(), this.argOptions.getIntOption('l', 0));
    }

    @Override
    protected String getAlgorithmSpecifics() {
        return "The --basisMapping specifies how the dependency paths that connect two words are\nmapped into dimensions.  The default behavior is to use only the word at the end\nof the path.\n\nThe --pathAcceptor specifies which paths in the corpus are treated as valid\ncontexts.  The default behavior is to use the minimum set of paths defined in\nPad\u221a\u2265 and Lapata (2007) paper.\n\nThe --pathWeighter specifies how to score paths that are accepted.  The default\nbehavior is not to weight the paths.\n";
    }

    @Override
    protected Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("pathAcceptor")) {
            properties.setProperty("edu.ucla.sspace.dri.DependencyVectorSpace.pathAcceptor", this.argOptions.getStringOption("pathAcceptor"));
        }
        if (this.argOptions.hasOption("pathWeighter")) {
            properties.setProperty("edu.ucla.sspace.dri.DependencyVectorSpace.pathWeighting", this.argOptions.getStringOption("pathWeighter"));
        }
        if (this.argOptions.hasOption("basisMapping")) {
            properties.setProperty("edu.ucla.sspace.dri.DependencyVectorSpace.basisMapping", this.argOptions.getStringOption("basisMapping"));
        }
        return properties;
    }
}

