/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.dependency.CoNLLDependencyExtractor;
import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyPathWeight;
import edu.ucla.sspace.dependency.FlatPathWeight;
import edu.ucla.sspace.dependency.UniversalPathAcceptor;
import edu.ucla.sspace.dv.DependencyPathBasisMapping;
import edu.ucla.sspace.dv.WordBasedBasisMapping;
import edu.ucla.sspace.mains.GenericWordsiMain;
import edu.ucla.sspace.text.DependencyFileDocumentIterator;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.DependencyContextExtractor;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;
import edu.ucla.sspace.wordsi.WordOccrrenceDependencyContextGenerator;
import edu.ucla.sspace.wordsi.psd.PseudoWordDependencyContextExtractor;
import edu.ucla.sspace.wordsi.semeval.SemEvalDependencyContextExtractor;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class DVWordsiMain
extends GenericWordsiMain {
    private DependencyPathBasisMapping basis;

    public static void main(String[] stringArray) throws Exception {
        DVWordsiMain dVWordsiMain = new DVWordsiMain();
        dVWordsiMain.run(stringArray);
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.removeOption('f');
        argOptions.addOption('p', "pathAcceptor", "Specifies the DependencyPathAcceptor to use when validating paths as features. (Default: Universal)", true, "CLASSNAME", "Optional");
        argOptions.addOption('G', "weightingFunction", "Specifies the class that will weight dependency paths. (Default: None)", true, "CLASSNAME", "Optional");
        argOptions.addOption('B', "basisMapping", "Specifies the class that deterine what aspect of a DependencyPath will as a feature in the word space. (Default: WordBasedBasisMapping)", true, "CLASSNAME", "Optional");
    }

    @Override
    protected void handleExtraOptions() {
        this.basis = this.argOptions.hasOption('L') ? (DependencyPathBasisMapping)this.loadObject(this.openLoadFile()) : (this.argOptions.hasOption('B') ? (DependencyPathBasisMapping)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption('B')) : new WordBasedBasisMapping());
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption('S')) {
            this.saveObject(this.openSaveFile(), this.basis);
        }
    }

    protected DependencyPathWeight getWeighter() {
        DependencyPathWeight dependencyPathWeight = this.argOptions.hasOption('G') ? (DependencyPathWeight)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption('G')) : new FlatPathWeight();
        return dependencyPathWeight;
    }

    protected DependencyPathAcceptor getAcceptor() {
        DependencyPathAcceptor dependencyPathAcceptor = this.argOptions.hasOption('p') ? (DependencyPathAcceptor)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption('p')) : new UniversalPathAcceptor();
        return dependencyPathAcceptor;
    }

    protected DependencyContextGenerator getContextGenerator() {
        return new WordOccrrenceDependencyContextGenerator(this.basis, this.getWeighter(), this.getAcceptor(), this.windowSize());
    }

    @Override
    protected ContextExtractor getExtractor() {
        DependencyContextGenerator dependencyContextGenerator = this.getContextGenerator();
        if (this.argOptions.hasOption('e')) {
            dependencyContextGenerator.setReadOnly(true);
        }
        if (this.argOptions.hasOption('E')) {
            return new SemEvalDependencyContextExtractor(new CoNLLDependencyExtractor(), dependencyContextGenerator);
        }
        if (this.argOptions.hasOption('P')) {
            return new PseudoWordDependencyContextExtractor((DependencyExtractor)new CoNLLDependencyExtractor(), dependencyContextGenerator, this.getPseudoWordMap());
        }
        return new DependencyContextExtractor(new CoNLLDependencyExtractor(), dependencyContextGenerator, this.argOptions.hasOption('h'));
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    @Override
    protected void addFileIterators(Collection<Iterator<Document>> collection, String[] stringArray) throws IOException {
        throw new UnsupportedOperationException("A file based document iterator does not exist");
    }

    @Override
    protected void addDocIterators(Collection<Iterator<Document>> collection, String[] stringArray) throws IOException {
        for (String string : stringArray) {
            collection.add(new DependencyFileDocumentIterator(string));
        }
    }
}

