/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.lra;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.WordNetDatabase;
import edu.ucla.sspace.lra.InterveningWordsPattern;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SVD;
import edu.ucla.sspace.util.BoundedSortedMap;
import edu.ucla.sspace.util.HashMultiMap;
import edu.ucla.sspace.util.Pair;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LatentRelationalAnalysis {
    public static final String LRA_DIMENSIONS_PROPERTY = "edu.ucla.sspace.lra.LRA.dimensions";
    public static final String LRA_INDEX_DIR = "edu.ucla.sspace.lra.LRA.index_dir";
    public static final String LRA_SKIP_INDEX = "edu.ucla.sspace.lra.LRA.skip_index";
    public static final String LRA_READ_MATRIX_FILE = "edu.ucla.sspace.lra.LRA.readMatrixFile";
    public static final String LRA_WRITE_MATRIX_FILE = "edu.ucla.sspace.lra.LRA.writeMatrixFile";
    private static final int NUM_SIM = 10;
    private static final int MAX_PHRASE = 5;
    private static final int NUM_FILTER = 3;
    private static final int MAX_INTER = 3;
    private static final int MIN_INTER = 1;
    private static final int NUM_PATTERNS = 4000;
    private List<String> original_pairs;
    private List<String> filtered_phrases;
    private Map<String, ArrayList<String>> original_to_alternates;
    private BoundedSortedMap<InterveningWordsPattern, Integer> pattern_list;
    private Map<Integer, String> matrix_row_map;
    private Map<Integer, InterveningWordsPattern> matrix_column_map;
    private String INDEX_DIR;
    private String DATA_DIR;

    public LatentRelationalAnalysis(String string, String string2, boolean bl) {
        Properties properties = System.getProperties();
        properties.setProperty("wordnet.database.dir", "/usr/share/wordnet");
        System.err.println("starting LRA...\n");
        this.INDEX_DIR = string2;
        this.DATA_DIR = string;
        if (bl) {
            LatentRelationalAnalysis.initializeIndex(this.INDEX_DIR, this.DATA_DIR);
        }
        this.original_pairs = new ArrayList<String>();
        this.filtered_phrases = new ArrayList<String>();
        this.original_to_alternates = new HashMap<String, ArrayList<String>>();
        this.pattern_list = new BoundedSortedMap(4000);
        this.matrix_column_map = new HashMap<Integer, InterveningWordsPattern>();
        this.matrix_row_map = new HashMap<Integer, String>();
    }

    public void loadAnalogiesFromFile(String string) {
        try {
            Scanner scanner = new Scanner(new File(string));
            while (scanner.hasNext()) {
                String string2 = scanner.next();
                if (!LatentRelationalAnalysis.isAnalogyFormat(string2)) {
                    System.err.println("\"" + string2 + "\" not in proper format.");
                    continue;
                }
                String[] stringArray = string2.split(":");
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                Synset[] synsetArray = LatentRelationalAnalysis.findAlternatives(string3);
                Synset[] synsetArray2 = LatentRelationalAnalysis.findAlternatives(string4);
                ArrayList<String> arrayList = new ArrayList<String>(LatentRelationalAnalysis.filterPhrases(this.INDEX_DIR, string3, string4, synsetArray, synsetArray2));
                this.filtered_phrases.addAll(arrayList);
                this.original_to_alternates.put(string3 + ":" + string4, arrayList);
            }
            scanner.close();
        }
        catch (Exception exception) {
            System.err.println("Could not read file.");
        }
    }

    public static Synset[] findAlternatives(String string) {
        WordNetDatabase wordNetDatabase = WordNetDatabase.getFileInstance();
        Synset[] synsetArray = wordNetDatabase.getSynsets(string);
        return synsetArray;
    }

    public static void initializeIndex(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        long l = new Date().getTime();
        try {
            int n = LatentRelationalAnalysis.index(file, file2);
            long l2 = new Date().getTime();
            System.err.println("Indexing " + n + " files took " + (l2 - l) + " milliseconds");
        }
        catch (IOException iOException) {
            System.err.println("Unable to index " + file + ": " + iOException.getMessage());
        }
    }

    private static int index(File file, File file2) throws IOException {
        if (!file2.exists() || !file2.isDirectory()) {
            throw new IOException(file2 + " does not exist or is not a directory");
        }
        IndexWriter indexWriter = new IndexWriter(file, (Analyzer)new StandardAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
        indexWriter.setUseCompoundFile(false);
        LatentRelationalAnalysis.indexDirectory(indexWriter, file2);
        int n = indexWriter.numDocs();
        indexWriter.optimize();
        indexWriter.close();
        return n;
    }

    private static HashSet<String> searchDirectoryForPattern(File file, String string, String string2) throws Exception {
        File[] fileArray = file.listFiles();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                hashSet.addAll(LatentRelationalAnalysis.searchDirectoryForPattern(file2, string, string2));
                continue;
            }
            if (!file2.getName().endsWith(".txt")) continue;
            Scanner scanner = new Scanner(file2);
            block1: while (scanner.hasNext()) {
                if (!string.equals(scanner.next())) continue;
                String string3 = "";
                for (int j = 0; j <= 3 && scanner.hasNext(); ++j) {
                    String string4 = scanner.next();
                    if (j >= 1 && string2.equals(string4)) {
                        hashSet.add(string3);
                        continue block1;
                    }
                    if (j > 0) {
                        string3 = string3 + " ";
                    }
                    string3 = string3 + string4;
                }
            }
        }
        return hashSet;
    }

    private static void indexDirectory(IndexWriter indexWriter, File file) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                LatentRelationalAnalysis.indexDirectory(indexWriter, file2);
                continue;
            }
            if (!file2.getName().endsWith(".txt")) continue;
            LatentRelationalAnalysis.indexFile(indexWriter, file2);
        }
    }

    private static void indexFile(IndexWriter indexWriter, File file) throws IOException {
        if (file.isHidden() || !file.exists() || !file.canRead()) {
            System.err.println("Could not write " + file.getName());
            return;
        }
        System.err.println("Indexing " + file.getCanonicalPath());
        Document document = new Document();
        document.add((Fieldable)new Field("path", file.getCanonicalPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field("modified", DateTools.timeToString((long)file.lastModified(), (DateTools.Resolution)DateTools.Resolution.MINUTE), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((Fieldable)new Field("contents", (Reader)new FileReader(file)));
        indexWriter.addDocument(document);
    }

    public static float countPhraseFrequencies(String string, String string2, String string3) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            try {
                return LatentRelationalAnalysis.searchPhrase(file, string2, string3);
            }
            catch (Exception exception) {
                System.err.println("Unable to search " + string);
                return 0.0f;
            }
        }
        System.err.println("Search failed: index directory does not exist");
        return 0.0f;
    }

    private static float searchPhrase(File file, String string, String string2) throws Exception {
        FSDirectory fSDirectory = FSDirectory.getDirectory((File)file);
        IndexSearcher indexSearcher = new IndexSearcher((Directory)fSDirectory);
        long l = new Date().getTime();
        QueryParser queryParser = new QueryParser("contents", (Analyzer)new StandardAnalyzer());
        queryParser.setPhraseSlop(5);
        String string3 = "\"" + string + " " + string2 + "\"";
        Query query = queryParser.parse(string3);
        indexSearcher.setSimilarity(new Similarity(){
            public static final long serialVersionUID = 1L;

            public float coord(int n, int n2) {
                return 1.0f;
            }

            public float queryNorm(float f) {
                return 1.0f;
            }

            public float tf(float f) {
                return f;
            }

            public float idf(int n, int n2) {
                return 1.0f;
            }

            public float lengthNorm(String string, int n) {
                return 1.0f;
            }

            public float sloppyFreq(int n) {
                return 1.0f;
            }
        });
        TopDocs topDocs = indexSearcher.search(query, 10);
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        float f = 0.0f;
        for (ScoreDoc scoreDoc : scoreDocArray) {
            Document document = indexSearcher.doc(scoreDoc.doc);
            f += scoreDoc.score;
        }
        long l2 = new Date().getTime();
        indexSearcher.close();
        return f;
    }

    public static ArrayList<String> filterPhrases(String string, String string2, String string3, Synset[] synsetArray, Synset[] synsetArray2) {
        String[] stringArray;
        String string4;
        int n;
        Float f;
        int n2;
        Object object;
        int n3;
        HashMultiMap<Float, Pair<String>> hashMultiMap = new HashMultiMap<Float, Pair<String>>();
        int n4 = 0;
        for (n3 = 0; n3 < 10 && n3 < synsetArray.length; ++n3) {
            object = synsetArray[n3].getWordForms();
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                if (object[n2].compareTo(string2) != 0) {
                    f = new Float(LatentRelationalAnalysis.countPhraseFrequencies(string, object[n2], string3));
                    hashMultiMap.put(f, new Pair<String>(object[n2], string3));
                    ++n4;
                }
                if (n4 >= 10) break;
            }
            if (n4 >= 10) break;
        }
        n4 = 0;
        for (n3 = 0; n3 < 10 && n3 < synsetArray2.length; ++n3) {
            object = synsetArray2[n3].getWordForms();
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                if (object[n2].compareTo(string3) != 0) {
                    f = new Float(LatentRelationalAnalysis.countPhraseFrequencies(string, string2, object[n2]));
                    hashMultiMap.put(f, new Pair<String>(string2, object[n2]));
                    ++n4;
                }
                if (n4 >= 10) break;
            }
            if (n4 >= 10) break;
        }
        Iterator iterator = hashMultiMap.keySet().iterator();
        object = new ArrayList();
        Float f2 = new Float(0.0);
        f = new Float(0.0);
        Float f3 = new Float(0.0);
        while (iterator.hasNext()) {
            Float f4 = (Float)iterator.next();
            if (f4.floatValue() > f2.floatValue()) {
                f3 = f;
                f = f2;
                f2 = f4;
                continue;
            }
            if (f4.floatValue() > f.floatValue()) {
                f3 = f;
                f = f4;
                continue;
            }
            if (!(f4.floatValue() > f3.floatValue())) continue;
            f3 = f4;
        }
        Iterator iterator2 = hashMultiMap.get(f2).iterator();
        for (n = 0; iterator2.hasNext() && n < 3; ++n) {
            string4 = iterator2.next().toString();
            stringArray = LatentRelationalAnalysis.parsePair(string4);
            ((ArrayList)object).add(stringArray[0] + ":" + stringArray[1]);
        }
        iterator2 = hashMultiMap.get(f).iterator();
        while (iterator2.hasNext() && n < 3) {
            string4 = iterator2.next().toString();
            stringArray = LatentRelationalAnalysis.parsePair(string4);
            ((ArrayList)object).add(stringArray[0] + ":" + stringArray[1]);
            ++n;
        }
        iterator2 = hashMultiMap.get(f3).iterator();
        while (iterator2.hasNext() && n < 3) {
            string4 = iterator2.next().toString();
            stringArray = LatentRelationalAnalysis.parsePair(string4);
            ((ArrayList)object).add(stringArray[0] + ":" + stringArray[1]);
            ++n;
        }
        ((ArrayList)object).add(string2 + ":" + string3);
        return object;
    }

    private static String combinatorialPatternMaker(String[] stringArray, int n, int n2) {
        String string = "";
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            string = (n2 & n3) != 0 ? string + stringArray[i] + "\\s" : string + "[\\w]+\\s";
            n3 <<= 1;
        }
        return string;
    }

    private static int countWildcardPhraseFrequencies(File file, String string) throws Exception {
        File[] fileArray = file.listFiles();
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                n += LatentRelationalAnalysis.countWildcardPhraseFrequencies(file2, string);
                continue;
            }
            if (!file2.getName().endsWith(".txt")) continue;
            Scanner scanner = new Scanner(file2);
            while (scanner.hasNext()) {
                String string2 = scanner.nextLine();
                if (!string2.matches(string)) continue;
                ++n;
            }
        }
        return n;
    }

    private static String[] parsePair(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(123) + 1;
        int n2 = string.indexOf(44);
        stringArray[0] = string.substring(n, n2);
        stringArray[1] = string.substring(n2 + 2, string.length() - 1);
        return stringArray;
    }

    public void findPatterns() throws Exception {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.filtered_phrases) {
            stringArray = string.split(":");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            hashSet.addAll(LatentRelationalAnalysis.searchDirectoryForPattern(new File(this.DATA_DIR), string2, string3));
        }
        for (String string : hashSet) {
            stringArray = string.split("\\s");
            int n = stringArray.length;
            for (int i = 0; i < (int)Math.pow(2.0, n); ++i) {
                String string4 = "\\s" + LatentRelationalAnalysis.combinatorialPatternMaker(stringArray, n, i);
                try {
                    int n2 = LatentRelationalAnalysis.countWildcardPhraseFrequencies(new File(this.DATA_DIR), ".*" + string4 + ".*");
                    InterveningWordsPattern interveningWordsPattern = new InterveningWordsPattern(string4);
                    interveningWordsPattern.setOccurrences(n2);
                    this.pattern_list.put(interveningWordsPattern, n2);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("could not perform wildcard search");
                }
            }
        }
    }

    public void mapColumns() {
        int n = 0;
        for (InterveningWordsPattern interveningWordsPattern : this.pattern_list.keySet()) {
            this.matrix_column_map.put(new Integer(n), interveningWordsPattern);
            InterveningWordsPattern interveningWordsPattern2 = new InterveningWordsPattern(interveningWordsPattern.getPattern());
            interveningWordsPattern2.setOccurrences(interveningWordsPattern.getOccurrences());
            interveningWordsPattern2.setReverse(true);
            this.matrix_column_map.put(new Integer(++n), interveningWordsPattern2);
            ++n;
        }
    }

    public void mapRows() {
        int n = 0;
        for (String string : this.filtered_phrases) {
            String[] stringArray = string.split(":");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            this.matrix_row_map.put(new Integer(n), string2 + ":" + string3);
            this.matrix_row_map.put(new Integer(++n), string3 + ":" + string2);
            ++n;
        }
    }

    public Matrix createSparseMatrix() {
        Matrix matrix = Matrices.create(this.matrix_row_map.size(), this.matrix_column_map.size(), false);
        for (int i = 0; i < this.matrix_row_map.size(); ++i) {
            String string = this.matrix_row_map.get(new Integer(i));
            String[] stringArray = string.split(":");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            for (int j = 0; j < this.matrix_column_map.size(); ++j) {
                InterveningWordsPattern interveningWordsPattern = this.matrix_column_map.get(new Integer(j));
                String string4 = interveningWordsPattern.getPattern();
                String string5 = interveningWordsPattern.getReverse() ? ".*\\s" + string3 + string4 + string2 + "\\s.*" : ".*\\s" + string2 + string4 + string3 + "\\s.*";
                try {
                    matrix.set(i, j, LatentRelationalAnalysis.countWildcardPhraseFrequencies(new File(this.DATA_DIR), string5));
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("could not perform wildcard search");
                }
            }
        }
        System.err.println("\nCompleted matrix generation.");
        return matrix;
    }

    public Matrix applyEntropyTransformations(Matrix matrix) {
        int n = matrix.columns();
        int n2 = matrix.rows();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                d += matrix.get(j, i);
            }
            if (d == 0.0) continue;
            double d2 = 0.0;
            for (int j = 0; j < n2; ++j) {
                double d3 = matrix.get(j, i) / d;
                if (d3 == 0.0) continue;
                d2 += d3 * Math.log10(d3);
            }
            double d4 = 1.0 - (d2 *= -1.0) / Math.log10(n2);
            for (int j = 0; j < n2; ++j) {
                matrix.set(j, i, d4 * Math.log10(matrix.get(j, i) + 1.0));
            }
        }
        return matrix;
    }

    private static int getIndexOfPair(String string, Map<Integer, String> map) {
        for (Integer n : map.keySet()) {
            if (!map.get(n).equals(string)) continue;
            return n;
        }
        return -1;
    }

    public double computeCosineSimilarity(String string, Matrix matrix) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        double d = 0.0;
        int n = 0;
        if (!LatentRelationalAnalysis.isAnalogyFormat(string, true)) {
            System.err.println("Analogy: \"" + string + "\" not in proper format");
            return 0.0;
        }
        String[] stringArray = string.split("::");
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (!LatentRelationalAnalysis.isAnalogyFormat(string3) || !LatentRelationalAnalysis.isAnalogyFormat(string4)) {
            System.err.println("Analogy: \"" + string + "\" not in proper format");
            return 0.0;
        }
        if (!this.original_to_alternates.containsKey(string3) || !this.original_to_alternates.containsKey(string4)) {
            String[] stringArray2 = string3.split(":");
            String string5 = stringArray2[1];
            object3 = stringArray2[0];
            object2 = string4.split(":");
            object = object2[1];
            string2 = object2[0];
            string3 = string5 + ":" + (String)object3;
            string4 = (String)object + ":" + string2;
            if (!this.original_to_alternates.containsKey(string3) || !this.original_to_alternates.containsKey(string4)) {
                System.err.println("Analogy: \"" + string + "\" not included in original pairs");
                return 0.0;
            }
        }
        double d2 = edu.ucla.sspace.common.Similarity.cosineSimilarity(matrix.getRow(LatentRelationalAnalysis.getIndexOfPair(string3, this.matrix_row_map)), matrix.getRow(LatentRelationalAnalysis.getIndexOfPair(string4, this.matrix_row_map)));
        d += d2;
        ++n;
        object3 = this.original_to_alternates.get(string3);
        object2 = this.original_to_alternates.get(string4);
        object = ((ArrayList)object3).iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            Iterator iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                double d3;
                String string6 = (String)iterator.next();
                int n2 = LatentRelationalAnalysis.getIndexOfPair(string2, this.matrix_row_map);
                int n3 = LatentRelationalAnalysis.getIndexOfPair(string6, this.matrix_row_map);
                if (n2 == -1 || n3 == -1 || !((d3 = edu.ucla.sspace.common.Similarity.cosineSimilarity(matrix.getRow(n2), matrix.getRow(n3))) >= d2)) continue;
                d += d3;
                ++n;
            }
        }
        if (n > 0) {
            return d / (double)n;
        }
        return 0.0;
    }

    public static Matrix[] computeSVD(Matrix matrix, int n) {
        try {
            File file = File.createTempFile("lra-term-document-matrix", ".dat");
            MatrixIO.writeMatrix(matrix, file, MatrixIO.Format.SVDLIBC_SPARSE_TEXT);
            Matrix[] matrixArray = SVD.svd(file, SVD.Algorithm.SVDLIBC, MatrixIO.Format.SVDLIBC_SPARSE_TEXT, n);
            if (matrixArray[1].rows() < matrixArray[0].columns()) {
                n = matrixArray[1].rows();
                System.err.println("Default dimensions too big...redoing SVD with new dimensions, k=" + n + " ...");
                matrixArray = SVD.svd(file, SVD.Algorithm.SVDLIBC, MatrixIO.Format.SVDLIBC_SPARSE_TEXT, n);
            }
            return matrixArray;
        }
        catch (Exception exception) {
            System.err.println("could not compute SVD\n");
            return null;
        }
    }

    public void evaluateAnalogies(Matrix matrix, String string, String string2) {
        try {
            Scanner scanner = new Scanner(new File(string));
            PrintStream printStream = new PrintStream(new FileOutputStream(string2));
            while (scanner.hasNext()) {
                String string3 = scanner.next();
                if (!LatentRelationalAnalysis.isAnalogyFormat(string3, true)) {
                    System.err.println("\"" + string3 + "\" not in proper format.");
                    continue;
                }
                double d = this.computeCosineSimilarity(string3, matrix);
                printStream.println(string3 + " = " + d);
            }
            scanner.close();
            printStream.close();
        }
        catch (Exception exception) {
            System.err.println("Could not read file.");
        }
    }

    public void evaluateAnalogies(Matrix matrix) {
        try {
            Scanner scanner = new Scanner(System.in);
            while (scanner.hasNext()) {
                String string = scanner.next();
                if (!LatentRelationalAnalysis.isAnalogyFormat(string, true)) {
                    System.err.println("\"" + string + "\" not in proper format.");
                    continue;
                }
                double d = this.computeCosineSimilarity(string, matrix);
                System.out.println(string + " = " + d);
            }
            scanner.close();
        }
        catch (Exception exception) {
            System.err.println("Could not read file.");
        }
    }

    public static void printMatrix(int n, int n2, Matrix matrix) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                System.out.print(matrix.get(j, i) + " ");
            }
            System.out.print("\n");
        }
        System.out.print("\n");
    }

    public static boolean isAnalogyFormat(String string) {
        return LatentRelationalAnalysis.isAnalogyFormat(string, false);
    }

    public static boolean isAnalogyFormat(String string, boolean bl) {
        if (bl) {
            return string.matches("[\\w]+:[\\w]+::[\\w]+:[\\w]+");
        }
        return string.matches("[\\w]+:[\\w]+");
    }
}

