/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.index;

import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.vector.TernaryVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class TernaryPermutationFunction
implements PermutationFunction<TernaryVector>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Random RANDOM = RandomIndexVectorGenerator.RANDOM;
    private final Map<Integer, Function> permutationToReordering = new HashMap<Integer, Function>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function getFunction(int n, int n2) {
        if (n == 0) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i;
            }
            return new Function(nArray, nArray);
        }
        Function function = this.permutationToReordering.get(n = Math.abs(n));
        if (function == null) {
            TernaryPermutationFunction ternaryPermutationFunction = this;
            synchronized (ternaryPermutationFunction) {
                function = this.permutationToReordering.get(n);
                if (function == null) {
                    int n3 = n - 1;
                    Function function2 = this.getFunction(n3, n2);
                    Integer[] integerArray = new Integer[n2];
                    for (int i = 0; i < n2; ++i) {
                        integerArray[i] = function2.forward[i];
                    }
                    List<Integer> list = Arrays.asList(integerArray);
                    Collections.shuffle(list, RANDOM);
                    int[] nArray = new int[n2];
                    int[] nArray2 = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray[i] = integerArray[i];
                        nArray2[integerArray[i].intValue()] = i;
                    }
                    function = new Function(nArray, nArray2);
                    this.permutationToReordering.put(n, function);
                }
            }
        }
        return function;
    }

    @Override
    public TernaryVector permute(TernaryVector ternaryVector, int n) {
        int[] nArray = ternaryVector.positiveDimensions();
        int[] nArray2 = ternaryVector.negativeDimensions();
        int[] nArray3 = Arrays.copyOf(nArray, nArray.length);
        int[] nArray4 = Arrays.copyOf(nArray2, nArray2.length);
        boolean bl = n < 0;
        int n2 = Math.abs(n);
        for (int i = 1; i <= n2; ++i) {
            int n3;
            Function function = this.getFunction(i, ternaryVector.length());
            int[] nArray5 = bl ? function.backward : function.forward;
            nArray = Arrays.copyOf(nArray3, nArray3.length);
            nArray2 = Arrays.copyOf(nArray4, nArray4.length);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray3[n3] = nArray5[nArray[n3]];
            }
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                nArray4[n3] = nArray5[nArray2[n3]];
            }
        }
        return new TernaryVector(ternaryVector.length(), nArray3, nArray4);
    }

    public String toString() {
        return "TernaryPermutationFunction";
    }

    private static class Function
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int[] forward;
        private final int[] backward;

        public Function(int[] nArray, int[] nArray2) {
            this.forward = nArray;
            this.backward = nArray2;
        }
    }
}

