/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.index;

import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class DefaultPermutationFunction
implements PermutationFunction<Vector>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Random RANDOM = RandomIndexVectorGenerator.RANDOM;
    private final Map<Integer, Function> permutationToReordering = new HashMap<Integer, Function>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Function getFunction(int n, int n2) {
        if (n == 0) {
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = i;
            }
            return new Function(nArray, nArray);
        }
        Function function = this.permutationToReordering.get(n = Math.abs(n));
        if (function == null) {
            DefaultPermutationFunction defaultPermutationFunction = this;
            synchronized (defaultPermutationFunction) {
                function = this.permutationToReordering.get(n);
                if (function == null) {
                    int n3 = n - 1;
                    Function function2 = this.getFunction(n3, n2);
                    Integer[] integerArray = new Integer[n2];
                    for (int i = 0; i < n2; ++i) {
                        integerArray[i] = function2.forward[i];
                    }
                    List<Integer> list = Arrays.asList(integerArray);
                    Collections.shuffle(list, RANDOM);
                    int[] nArray = new int[n2];
                    int[] nArray2 = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray[i] = integerArray[i];
                        nArray2[integerArray[i].intValue()] = i;
                    }
                    function = new Function(nArray, nArray2);
                    this.permutationToReordering.put(n, function);
                }
            }
        }
        return function;
    }

    @Override
    public Vector permute(Vector vector, int n) {
        int n2;
        if (vector instanceof TernaryVector) {
            return this.permute((TernaryVector)vector, n, vector.length());
        }
        Vector vector2 = Vectors.instanceOf(vector);
        int[] nArray = null;
        int[] nArray2 = null;
        if (vector instanceof SparseVector) {
            nArray2 = ((SparseVector)vector).getNonZeroIndices();
            nArray = Arrays.copyOf(nArray2, nArray2.length);
        } else {
            nArray = new int[vector.length()];
            for (n2 = 0; n2 < vector.length(); ++n2) {
                nArray[n2] = n2;
            }
        }
        n2 = n < 0 ? 1 : 0;
        int n3 = Math.abs(n);
        for (int i = 1; i <= n3; ++i) {
            Function function = this.getFunction(i, vector.length());
            int[] nArray3 = n2 != 0 ? function.backward : function.forward;
            nArray2 = Arrays.copyOf(nArray, nArray.length);
            for (int j = 0; j < nArray2.length; ++j) {
                nArray[j] = nArray3[nArray2[j]];
            }
        }
        for (int j : nArray) {
            vector2.set(j, vector.getValue(j));
        }
        return vector2;
    }

    private Vector permute(TernaryVector ternaryVector, int n, int n2) {
        int[] nArray = ternaryVector.positiveDimensions();
        int[] nArray2 = ternaryVector.negativeDimensions();
        int[] nArray3 = Arrays.copyOf(nArray, nArray.length);
        int[] nArray4 = Arrays.copyOf(nArray2, nArray2.length);
        boolean bl = n < 0;
        int n3 = Math.abs(n);
        for (int i = 1; i <= n3; ++i) {
            int n4;
            Function function = this.getFunction(i, n2);
            int[] nArray5 = bl ? function.backward : function.forward;
            nArray = Arrays.copyOf(nArray3, nArray3.length);
            nArray2 = Arrays.copyOf(nArray4, nArray4.length);
            for (n4 = 0; n4 < nArray.length; ++n4) {
                nArray3[n4] = nArray5[nArray[n4]];
            }
            for (n4 = 0; n4 < nArray2.length; ++n4) {
                nArray4[n4] = nArray5[nArray2[n4]];
            }
        }
        return new TernaryVector(n2, nArray3, nArray4);
    }

    public String toString() {
        return "DefaultPermutationFunction";
    }

    private static class Function
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int[] forward;
        private final int[] backward;

        public Function(int[] nArray, int[] nArray2) {
            this.forward = nArray;
            this.backward = nArray2;
        }
    }
}

