/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.grefenstette;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.matrix.GrowingSparseMatrix;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Grefenstette
implements SemanticSpace {
    private static final Logger LOGGER = Logger.getLogger(Grefenstette.class.getName());
    private final File wordRelations;
    private final PrintWriter wordRelationsWriter;
    private final Map<String, Integer> objectTable;
    private final Map<String, Integer> attributeTable;
    private final Matrix syntacticCooccurrence;
    private final AtomicInteger objectCounter;
    private final AtomicInteger attributeCounter;

    public Grefenstette() {
        try {
            this.wordRelations = File.createTempFile("word-relation-list", "txt");
            this.wordRelationsWriter = new PrintWriter(this.wordRelations);
            this.objectTable = new HashMap<String, Integer>();
            this.attributeTable = new HashMap<String, Integer>();
            this.syntacticCooccurrence = new GrowingSparseMatrix();
            this.objectCounter = new AtomicInteger(0);
            this.attributeCounter = new AtomicInteger(0);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) {
        ArrayList<Pair<String>> arrayList = new ArrayList<Pair<String>>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string6 = this.getNextTag(string);
        while (string6 != null) {
            String string7;
            int n = string.indexOf(string6);
            string = string.substring(n);
            arrayList.clear();
            if (string6.equals("NP")) {
                while (string.charAt(0) != ')') {
                    string6 = this.getNextTag(string);
                    if (this.isPhraseOrClause(string6) || this.isPreposition(string6)) {
                        string = string.substring(string.indexOf(string6) + string6.length());
                        break;
                    }
                    if (this.inStartSet(string6) || this.inReceiveSet(string6)) {
                        try {
                            string7 = string.substring(string.indexOf(" ", string.indexOf(string6)) + 1, string.indexOf(")"));
                            arrayList.add(new Pair<String>(string6, string7));
                            string = string.substring(string.indexOf(")", string.indexOf(string7)) + 1);
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            string = string.substring(string.indexOf(")"));
                        }
                        continue;
                    }
                    string = string.substring(string.indexOf(")") + 1);
                }
                if (!arrayList.isEmpty()) {
                    String string8 = (String)((Pair)arrayList.get((int)(arrayList.size() - 1))).y;
                    if (string5.equals("PP") && string4.equals("NP") && string2.length() != 0) {
                        this.wordRelationsWriter.println(string2 + " " + string8);
                        this.addRelation(string2, string8);
                    }
                    if (string5.equals("PP") && string4.equals("VP") && string3.length() != 0) {
                        this.wordRelationsWriter.println(string3 + " " + string8);
                        this.addRelation(string3, string8);
                    } else if (string5.equals("VP")) {
                        this.wordRelationsWriter.println(string3 + " " + string8);
                        this.addRelation(string3, string8);
                    }
                    string2 = string8;
                }
                if (string.charAt(0) == ')') {
                    this.processWordsInNP(arrayList);
                    if (!"NP".equals(string5)) {
                        string4 = string5;
                        string5 = "NP";
                    }
                }
            } else if (string6.equals("VP")) {
                while (string6 != null && string6.startsWith("V")) {
                    if (string6.startsWith("VB")) {
                        string3 = string7 = string.substring(string.indexOf(" ", string.indexOf(string6)) + 1, string.indexOf(")"));
                    }
                    string = string.substring(string.indexOf(string6) + 1);
                    string6 = this.getNextTag(string);
                }
                if (string5.equals("NP") && string2.length() != 0) {
                    this.wordRelationsWriter.println(string2 + " " + string3);
                    this.addRelation(string2, string3);
                }
                if (!string5.equals("VP")) {
                    string4 = string5;
                    string5 = "VP";
                }
            } else if (this.isPhraseOrClause(string6) || this.isPreposition(string6)) {
                string = string.substring(string.indexOf(string6) + string6.length());
                if (!string6.equals(string5)) {
                    string4 = string5;
                    string5 = string6;
                }
            } else {
                string = string.substring(string.indexOf(string6) + string6.length());
            }
            string6 = this.getNextTag(string);
        }
    }

    private void addRelation(String string, String string2) {
        int n;
        int n2;
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        if (this.objectTable.containsKey(string)) {
            n2 = this.objectTable.get(string);
        } else {
            n2 = this.objectCounter.getAndIncrement();
            this.objectTable.put(string, n2);
            System.out.println(string + " " + n2);
        }
        if (this.attributeTable.containsKey(string2)) {
            n = this.attributeTable.get(string2);
        } else {
            n = this.attributeCounter.getAndIncrement();
            this.attributeTable.put(string2, n);
        }
        if (n2 < this.syntacticCooccurrence.rows() && n < this.syntacticCooccurrence.columns()) {
            double d = this.syntacticCooccurrence.get(n2, n);
            this.syntacticCooccurrence.set(n2, n, d + 1.0);
        } else {
            this.syntacticCooccurrence.set(n2, n, 1.0);
        }
    }

    private void processWordsInNP(ArrayList<Pair<String>> arrayList) {
        if (arrayList.size() > 1) {
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                if (!this.inStartSet((String)arrayList.get((int)i).x)) continue;
                for (int j = i + 1; j < arrayList.size(); ++j) {
                    if (!this.inReceiveSet((String)arrayList.get((int)j).x)) continue;
                    this.wordRelationsWriter.println((String)arrayList.get((int)j).y + " " + (String)arrayList.get((int)i).y);
                    this.addRelation((String)arrayList.get((int)j).y, (String)arrayList.get((int)i).y);
                }
            }
        }
    }

    private boolean inStartSet(String string) {
        return string.startsWith("NN") || string.startsWith("JJ") || string.startsWith("RB") || string.startsWith("CD");
    }

    private boolean inReceiveSet(String string) {
        return string.startsWith("NN") || string.startsWith("VB");
    }

    private boolean isPreposition(String string) {
        return string.startsWith("PP");
    }

    private boolean isPhraseOrClause(String string) {
        return !string.equals("SYM") && string.startsWith("S") || string.equals("ADJP") || string.equals("ADVP") || string.equals("CONJP") || string.equals("FRAG") || string.equals("INTJ") || string.equals("LST") || string.equals("NAC") || string.equals("NP") || string.equals("NX") || string.equals("PP") || string.equals("PRN") || string.equals("PRT") || string.equals("QP") || string.equals("RRC") || string.equals("UCP") || string.equals("VP") || string.startsWith("WH") || string.equals("X");
    }

    private String getNextTag(String string) {
        int n = string.indexOf("(");
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(" ", n);
        if (n2 < 0) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        if (string2.length() > 0) {
            return string2;
        }
        string = string.substring(n + 1);
        return this.getNextTag(string);
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.objectTable.keySet());
    }

    @Override
    public Vector getVector(String string) {
        int n;
        if (this.objectTable.containsKey(string = string.toLowerCase()) && (n = this.objectTable.get(string).intValue()) < this.syntacticCooccurrence.rows()) {
            return this.syntacticCooccurrence.getRowVector(n);
        }
        return null;
    }

    @Override
    public void processSpace(Properties properties) {
    }

    @Override
    public String getSpaceName() {
        return "grefenstette-syntatic-analysis";
    }

    @Override
    public int getVectorLength() {
        return this.syntacticCooccurrence.columns();
    }
}

