/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.evaluation.MultipleChoiceQuestion;
import edu.ucla.sspace.evaluation.SimpleMultipleChoiceQuestion;
import edu.ucla.sspace.evaluation.WordChoiceEvaluation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class ESLSynonymEvaluation
implements WordChoiceEvaluation {
    private final Collection<MultipleChoiceQuestion> questions;
    private final String dataFileName;

    public ESLSynonymEvaluation(String string) {
        this(new File(string));
    }

    public ESLSynonymEvaluation(File file) {
        this.questions = ESLSynonymEvaluation.parseTestFile(file);
        this.dataFileName = file.getName();
    }

    private static Collection<MultipleChoiceQuestion> parseTestFile(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            LinkedList<MultipleChoiceQuestion> linkedList = new LinkedList<MultipleChoiceQuestion>();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#") || string.length() == 0) continue;
                String[] stringArray = string.split("\\|");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].trim();
                }
                String string2 = stringArray[0];
                String[] stringArray2 = new String[stringArray.length - 1];
                List<String> list = Arrays.asList(Arrays.copyOfRange(stringArray, 1, stringArray.length - 1));
                linkedList.add(new SimpleMultipleChoiceQuestion(string2, list, 0));
            }
            return linkedList;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public Collection<MultipleChoiceQuestion> getQuestions() {
        return this.questions;
    }

    public String toString() {
        return "Word Choice [" + this.dataFileName + "]";
    }
}

