/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dv;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dv.DependencyPathBasisMapping;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RelationPathBasisMapping
implements DependencyPathBasisMapping {
    private Map<PathSignature, Integer> pathToIndex = new HashMap<PathSignature, Integer>();
    private String[] indexToPathCache = new String[0];
    private boolean readOnly = false;

    @Override
    public int getDimension(DependencyPath dependencyPath) {
        return this.getDimension(new PathSignature(dependencyPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private int getDimension(PathSignature pathSignature) {
        Integer n = this.pathToIndex.get(pathSignature);
        if (n == null && !this.readOnly) {
            RelationPathBasisMapping relationPathBasisMapping = this;
            synchronized (relationPathBasisMapping) {
                n = this.pathToIndex.get(pathSignature);
                if (n == null) {
                    int n2 = this.pathToIndex.size();
                    this.pathToIndex.put(pathSignature, n2);
                    return n2;
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDimensionDescription(int n) {
        if (n < 0 || n > this.pathToIndex.size()) {
            throw new IllegalArgumentException("invalid dimension: " + n);
        }
        if (this.pathToIndex.size() > this.indexToPathCache.length) {
            RelationPathBasisMapping relationPathBasisMapping = this;
            synchronized (relationPathBasisMapping) {
                this.indexToPathCache = new String[this.pathToIndex.size()];
                for (Map.Entry<PathSignature, Integer> entry : this.pathToIndex.entrySet()) {
                    this.indexToPathCache[entry.getValue().intValue()] = entry.getKey().toString();
                }
            }
        }
        return this.indexToPathCache[n];
    }

    @Override
    public int numDimensions() {
        return this.pathToIndex.size();
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Set<String> keySet() {
        return null;
    }

    private static class PathSignature {
        private final String[] relations;
        private int hashCode = 0;

        public PathSignature(DependencyPath dependencyPath) {
            this.relations = new String[dependencyPath.length() - 1];
            for (int i = 0; i < dependencyPath.length(); ++i) {
                if (i + 1 >= dependencyPath.length()) continue;
                this.relations[i] = dependencyPath.getRelation(i);
            }
        }

        public boolean equals(Object object) {
            if (object instanceof PathSignature) {
                PathSignature pathSignature = (PathSignature)object;
                return this.hashCode() == pathSignature.hashCode() && Arrays.equals(this.relations, pathSignature.relations);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Arrays.hashCode(this.relations);
            }
            return this.hashCode;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.relations[0]);
            for (int i = 0; i < this.relations.length; ++i) {
                stringBuilder.append("-").append(this.relations[i]);
            }
            return stringBuilder.toString();
        }
    }
}

