/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dri;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyExtractorManager;
import edu.ucla.sspace.dependency.DependencyIterator;
import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPermutationFunction;
import edu.ucla.sspace.dependency.DependencyRelationAcceptor;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.UniversalRelationAcceptor;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.CompactSparseIntegerVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class DependencyRandomIndexing
implements SemanticSpace {
    public static final String PROPERTY_PREFIX = "edu.ucla.sspace.dri.DependencyRandomIndexing";
    public static final String VECTOR_LENGTH_PROPERTY = "edu.ucla.sspace.dri.DependencyRandomIndexing.indexVectorLength";
    public static final String DEPENDENCY_ACCEPTOR_PROPERTY = "edu.ucla.sspace.dri.DependencyRandomIndexing.dependencyAcceptor";
    public static final String DEPENDENCY_PATH_LENGTH_PROPERTY = "edu.ucla.sspace.dri.DependencyRandomIndexing.dependencyPathLength";
    public static final int DEFAULT_VECTOR_LENGTH = 50000;
    public static final int DEFAULT_DEPENDENCY_PATH_LENGTH = Integer.MAX_VALUE;
    public static final String SSPACE_NAME = "dependency-random-indexing";
    private static final Logger LOGGER = Logger.getLogger(DependencyRandomIndexing.class.getName());
    private Map<String, TernaryVector> indexMap;
    private final DependencyPermutationFunction<TernaryVector> permFunc;
    private ConcurrentMap<String, IntegerVector> wordSpace;
    private final int vectorLength;
    private final DependencyExtractor parser;
    private final DependencyRelationAcceptor acceptor;
    private final int pathLength;
    private Set<String> semanticFilter;

    public DependencyRandomIndexing(DependencyPermutationFunction<TernaryVector> dependencyPermutationFunction) {
        this(dependencyPermutationFunction, System.getProperties());
    }

    public DependencyRandomIndexing(DependencyPermutationFunction<TernaryVector> dependencyPermutationFunction, Properties properties) {
        this.permFunc = dependencyPermutationFunction;
        this.parser = DependencyExtractorManager.getDefaultExtractor();
        String string = properties.getProperty(VECTOR_LENGTH_PROPERTY);
        this.vectorLength = string != null ? Integer.parseInt(string) : 50000;
        String string2 = properties.getProperty(DEPENDENCY_PATH_LENGTH_PROPERTY);
        this.pathLength = string2 != null ? Integer.parseInt(string2) : Integer.MAX_VALUE;
        String string3 = properties.getProperty(DEPENDENCY_ACCEPTOR_PROPERTY);
        this.acceptor = string3 != null ? (DependencyRelationAcceptor)ReflectionUtil.getObjectInstance(string3) : new UniversalRelationAcceptor();
        RandomIndexVectorGenerator randomIndexVectorGenerator = new RandomIndexVectorGenerator(this.vectorLength, properties);
        this.indexMap = new GeneratorMap<TernaryVector>(randomIndexVectorGenerator);
        this.wordSpace = new ConcurrentHashMap<String, IntegerVector>();
        this.semanticFilter = new HashSet<String>();
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.wordSpace.keySet());
    }

    @Override
    public Vector getVector(String string) {
        return Vectors.immutable((IntegerVector)this.wordSpace.get(string));
    }

    public DependencyPermutationFunction<TernaryVector> getPermutations() {
        return this.permFunc;
    }

    public Map<String, TernaryVector> getWordToVectorMap() {
        return this.indexMap;
    }

    public void setWordToVectorMap(Map<String, TernaryVector> map) {
        this.indexMap = map;
    }

    @Override
    public String getSpaceName() {
        return "dependency-random-indexing-" + this.vectorLength;
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        DependencyTreeNode[] dependencyTreeNodeArray = null;
        while ((dependencyTreeNodeArray = this.parser.readNextTree(bufferedReader)) != null) {
            if (dependencyTreeNodeArray.length == 0) continue;
            for (int i = 0; i < dependencyTreeNodeArray.length; ++i) {
                String string = dependencyTreeNodeArray[i].word();
                if (!this.acceptWord(string)) continue;
                IntegerVector integerVector = this.getSemanticVector(string);
                DependencyIterator dependencyIterator = new DependencyIterator(dependencyTreeNodeArray[i], this.acceptor, this.pathLength);
                while (dependencyIterator.hasNext()) {
                    DependencyPath dependencyPath = (DependencyPath)dependencyIterator.next();
                    TernaryVector ternaryVector = this.indexMap.get(dependencyPath.last().word());
                    if (this.permFunc != null) {
                        ternaryVector = this.permFunc.permute(ternaryVector, dependencyPath);
                    }
                    DependencyRandomIndexing.add(integerVector, ternaryVector);
                }
            }
        }
        bufferedReader.close();
    }

    @Override
    public void processSpace(Properties properties) {
    }

    public void setWordToIndexVector(Map<String, TernaryVector> map) {
        this.indexMap = map;
    }

    public void setSemanticFilter(Set<String> set) {
        this.semanticFilter.clear();
        this.semanticFilter.addAll(set);
    }

    private boolean acceptWord(String string) {
        return this.semanticFilter.isEmpty() || this.semanticFilter.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(IntegerVector integerVector, TernaryVector ternaryVector) {
        IntegerVector integerVector2 = integerVector;
        synchronized (integerVector2) {
            for (int n : ternaryVector.positiveDimensions()) {
                integerVector.add(n, 1);
            }
            for (int n : ternaryVector.negativeDimensions()) {
                integerVector.add(n, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntegerVector getSemanticVector(String string) {
        IntegerVector integerVector = (IntegerVector)this.wordSpace.get(string);
        if (integerVector == null) {
            DependencyRandomIndexing dependencyRandomIndexing = this;
            synchronized (dependencyRandomIndexing) {
                integerVector = (IntegerVector)this.wordSpace.get(string);
                if (integerVector == null) {
                    integerVector = new CompactSparseIntegerVector(this.vectorLength);
                    this.wordSpace.put(string, integerVector);
                }
            }
        }
        return integerVector;
    }
}

