/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dependency;

import edu.ucla.sspace.dependency.DependencyExtractor;
import java.util.HashMap;
import java.util.Map;

public class DependencyExtractorManager {
    private static DependencyExtractor defaultExtractor;
    private static Map<String, DependencyExtractor> nameToExtractor;

    private DependencyExtractorManager() {
    }

    public static synchronized void addExtractor(String string, DependencyExtractor dependencyExtractor) {
        DependencyExtractorManager.addExtractor(string, dependencyExtractor, defaultExtractor == null);
    }

    public static synchronized void addExtractor(String string, DependencyExtractor dependencyExtractor, boolean bl) {
        if (dependencyExtractor == null) {
            throw new NullPointerException("Extractor cannot be null" + string);
        }
        if (string == null) {
            throw new NullPointerException("Extractor cannot have null name");
        }
        nameToExtractor.put(string, dependencyExtractor);
        if (bl) {
            defaultExtractor = dependencyExtractor;
        }
    }

    public static synchronized DependencyExtractor getExtractor(String string) {
        DependencyExtractor dependencyExtractor = nameToExtractor.get(string);
        if (dependencyExtractor == null) {
            throw new IllegalArgumentException("No extactor with name " + string);
        }
        return dependencyExtractor;
    }

    public static synchronized DependencyExtractor getDefaultExtractor() {
        if (defaultExtractor == null) {
            throw new IllegalStateException("No extractors available");
        }
        return defaultExtractor;
    }

    static {
        nameToExtractor = new HashMap<String, DependencyExtractor>();
    }
}

