/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.common;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.matrix.ArrayMatrix;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StaticSemanticSpace
implements SemanticSpace,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(StaticSemanticSpace.class.getName());
    private Matrix wordSpace;
    private Map<String, Integer> termToIndex;
    private String spaceName;

    public StaticSemanticSpace(String string) throws IOException {
        this(new File(string));
    }

    public StaticSemanticSpace(File file) throws IOException {
        this.spaceName = file.getName();
        SemanticSpaceIO.SSpaceFormat sSpaceFormat = SemanticSpaceIO.getFormat(file);
        if (sSpaceFormat == null) {
            throw new Error("Unrecognzied format in file: " + file.getName());
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        dataInputStream.readInt();
        this.loadFromFormat(dataInputStream, sSpaceFormat);
    }

    @Deprecated
    public StaticSemanticSpace(File file, SemanticSpaceIO.SSpaceFormat sSpaceFormat) throws IOException {
        this.loadFromFormat(new BufferedInputStream(new FileInputStream(file)), sSpaceFormat);
        this.spaceName = file.getName();
    }

    private void loadFromFormat(InputStream inputStream, SemanticSpaceIO.SSpaceFormat sSpaceFormat) throws IOException {
        this.termToIndex = new LinkedHashMap<String, Integer>();
        Matrix matrix = null;
        long l = System.currentTimeMillis();
        switch (sSpaceFormat) {
            case TEXT: {
                matrix = Matrices.synchronizedMatrix(this.loadText(inputStream));
                break;
            }
            case BINARY: {
                matrix = Matrices.synchronizedMatrix(this.loadBinary(inputStream));
                break;
            }
            case SPARSE_TEXT: {
                matrix = this.loadSparseText(inputStream);
                break;
            }
            case SPARSE_BINARY: {
                matrix = this.loadSparseBinary(inputStream);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("loaded " + (Object)((Object)sSpaceFormat) + " .sspace file in " + (System.currentTimeMillis() - l) + "ms");
        }
        this.wordSpace = matrix;
    }

    private Matrix loadText(InputStream inputStream) throws IOException {
        ArrayMatrix arrayMatrix = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("Empty .sspace file");
        }
        String[] stringArray = string.split("\\s");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = 0;
        double[] dArray = new double[n2];
        arrayMatrix = new ArrayMatrix(n, n2);
        while ((string = bufferedReader.readLine()) != null) {
            if (n3 >= n) {
                throw new IOException("More rows than specified");
            }
            String[] stringArray2 = string.split("\\|");
            String[] stringArray3 = stringArray2[1].split("\\s");
            this.termToIndex.put(stringArray2[0], n3);
            if (stringArray3.length != n2) {
                throw new IOException("improperly formated semantic space file");
            }
            for (int i = 0; i < n2; ++i) {
                double d;
                dArray[i] = d = Double.parseDouble(stringArray3[i]);
            }
            arrayMatrix.setRow(n3, dArray);
            ++n3;
        }
        if (n3 != n) {
            throw new IOException(String.format("Expected %d rows; saw %d", n, n3));
        }
        return arrayMatrix;
    }

    private Matrix loadSparseText(InputStream inputStream) throws IOException {
        Matrix matrix = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOError(new Throwable("An empty file has been passed in"));
        }
        String[] stringArray = string.split("\\s");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = 0;
        matrix = Matrices.create(n, n2, false);
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray2 = string.split("\\|");
            String[] stringArray3 = stringArray2[1].split(",");
            this.termToIndex.put(stringArray2[0], n3);
            for (int i = 0; i < stringArray3.length; i += 2) {
                int n4 = Integer.parseInt(stringArray3[i]);
                double d = Double.parseDouble(stringArray3[i + 1]);
                matrix.set(n3, n4, d);
            }
            ++n3;
        }
        return matrix;
    }

    private Matrix loadBinary(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        ArrayMatrix arrayMatrix = new ArrayMatrix(n, n2);
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            this.termToIndex.put(string, i);
            for (int j = 0; j < n2; ++j) {
                dArray[j] = dataInputStream.readDouble();
            }
            arrayMatrix.setRow(i, dArray);
        }
        return arrayMatrix;
    }

    private Matrix loadSparseBinary(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        CompactSparseVector[] compactSparseVectorArray = new CompactSparseVector[n];
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            this.termToIndex.put(string, i);
            int n3 = dataInputStream.readInt();
            int[] nArray = new int[n3];
            double[] dArray = new double[n3];
            for (int j = 0; j < n3; ++j) {
                int n4 = dataInputStream.readInt();
                double d = dataInputStream.readDouble();
                nArray[j] = n4;
                dArray[j] = d;
            }
            compactSparseVectorArray[i] = new CompactSparseVector(nArray, dArray, n2);
        }
        return Matrices.asSparseMatrix(Arrays.asList(compactSparseVectorArray));
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.termToIndex.keySet());
    }

    @Override
    public Vector getVector(String string) {
        Integer n = this.termToIndex.get(string);
        return n == null ? null : this.wordSpace.getRowVector(n);
    }

    @Override
    public String getSpaceName() {
        return this.spaceName;
    }

    @Override
    public int getVectorLength() {
        return this.wordSpace.columns();
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) {
        throw new UnsupportedOperationException("StaticSemanticSpace instances cannot be updated");
    }

    @Override
    public void processSpace(Properties properties) {
        throw new UnsupportedOperationException("StaticSemanticSpace instances cannot be updated");
    }
}

